// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrincipalType;
import java.io.IOException;

/**
 * Represents an Active Directory administrator.
 */
@Fluent
public final class ActiveDirectoryAdministratorInner extends ProxyResource {
    /*
     * Properties of the active directory administrator.
     */
    private AdministratorProperties innerProperties = new AdministratorProperties();

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ActiveDirectoryAdministratorInner class.
     */
    public ActiveDirectoryAdministratorInner() {
    }

    /**
     * Get the innerProperties property: Properties of the active directory administrator.
     * 
     * @return the innerProperties value.
     */
    private AdministratorProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the principalType property: The principal type used to represent the type of Active Directory Administrator.
     * 
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    /**
     * Set the principalType property: The principal type used to represent the type of Active Directory Administrator.
     * 
     * @param principalType the principalType value to set.
     * @return the ActiveDirectoryAdministratorInner object itself.
     */
    public ActiveDirectoryAdministratorInner withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    /**
     * Get the principalName property: Active Directory administrator principal name.
     * 
     * @return the principalName value.
     */
    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    /**
     * Set the principalName property: Active Directory administrator principal name.
     * 
     * @param principalName the principalName value to set.
     * @return the ActiveDirectoryAdministratorInner object itself.
     */
    public ActiveDirectoryAdministratorInner withPrincipalName(String principalName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withPrincipalName(principalName);
        return this;
    }

    /**
     * Get the objectId property: The objectId of the Active Directory administrator.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.innerProperties() == null ? null : this.innerProperties().objectId();
    }

    /**
     * Set the objectId property: The objectId of the Active Directory administrator.
     * 
     * @param objectId the objectId value to set.
     * @return the ActiveDirectoryAdministratorInner object itself.
     */
    public ActiveDirectoryAdministratorInner withObjectId(String objectId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withObjectId(objectId);
        return this;
    }

    /**
     * Get the tenantId property: The tenantId of the Active Directory administrator.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    /**
     * Set the tenantId property: The tenantId of the Active Directory administrator.
     * 
     * @param tenantId the tenantId value to set.
     * @return the ActiveDirectoryAdministratorInner object itself.
     */
    public ActiveDirectoryAdministratorInner withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorProperties();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model ActiveDirectoryAdministratorInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ActiveDirectoryAdministratorInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActiveDirectoryAdministratorInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActiveDirectoryAdministratorInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ActiveDirectoryAdministratorInner.
     */
    public static ActiveDirectoryAdministratorInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActiveDirectoryAdministratorInner deserializedActiveDirectoryAdministratorInner
                = new ActiveDirectoryAdministratorInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.innerProperties
                        = AdministratorProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActiveDirectoryAdministratorInner;
        });
    }
}
