// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigurationDataType;
import java.io.IOException;

/**
 * Represents a Configuration.
 */
@Fluent
public final class ConfigurationInner extends ProxyResource {
    /*
     * The properties of a configuration.
     */
    private ConfigurationProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ConfigurationInner class.
     */
    public ConfigurationInner() {
    }

    /**
     * Get the innerProperties property: The properties of a configuration.
     * 
     * @return the innerProperties value.
     */
    private ConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the value property: Value of the configuration. Required to update the configuration.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: Value of the configuration. Required to update the configuration.
     * 
     * @param value the value value to set.
     * @return the ConfigurationInner object itself.
     */
    public ConfigurationInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Get the description property: Description of the configuration.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the defaultValue property: Default value of the configuration.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultValue();
    }

    /**
     * Get the dataType property: Data type of the configuration.
     * 
     * @return the dataType value.
     */
    public ConfigurationDataType dataType() {
        return this.innerProperties() == null ? null : this.innerProperties().dataType();
    }

    /**
     * Get the allowedValues property: Allowed values of the configuration.
     * 
     * @return the allowedValues value.
     */
    public String allowedValues() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedValues();
    }

    /**
     * Get the source property: Source of the configuration. Required to update the configuration.
     * 
     * @return the source value.
     */
    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: Source of the configuration. Required to update the configuration.
     * 
     * @param source the source value to set.
     * @return the ConfigurationInner object itself.
     */
    public ConfigurationInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the isDynamicConfig property: Configuration dynamic or static.
     * 
     * @return the isDynamicConfig value.
     */
    public Boolean isDynamicConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().isDynamicConfig();
    }

    /**
     * Get the isReadOnly property: Configuration read-only or not.
     * 
     * @return the isReadOnly value.
     */
    public Boolean isReadOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().isReadOnly();
    }

    /**
     * Get the isConfigPendingRestart property: Configuration is pending restart or not.
     * 
     * @return the isConfigPendingRestart value.
     */
    public Boolean isConfigPendingRestart() {
        return this.innerProperties() == null ? null : this.innerProperties().isConfigPendingRestart();
    }

    /**
     * Get the unit property: Configuration unit.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.innerProperties() == null ? null : this.innerProperties().unit();
    }

    /**
     * Get the documentationLink property: Configuration documentation link.
     * 
     * @return the documentationLink value.
     */
    public String documentationLink() {
        return this.innerProperties() == null ? null : this.innerProperties().documentationLink();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConfigurationInner.
     */
    public static ConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationInner deserializedConfigurationInner = new ConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedConfigurationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedConfigurationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedConfigurationInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedConfigurationInner.innerProperties = ConfigurationProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedConfigurationInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationInner;
        });
    }
}
