// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigurationDataType;
import java.io.IOException;

/**
 * The properties of a configuration.
 */
@Fluent
public final class ConfigurationProperties implements JsonSerializable<ConfigurationProperties> {
    /*
     * Value of the configuration. Required to update the configuration.
     */
    private String value;

    /*
     * Description of the configuration.
     */
    private String description;

    /*
     * Default value of the configuration.
     */
    private String defaultValue;

    /*
     * Data type of the configuration.
     */
    private ConfigurationDataType dataType;

    /*
     * Allowed values of the configuration.
     */
    private String allowedValues;

    /*
     * Source of the configuration. Required to update the configuration.
     */
    private String source;

    /*
     * Configuration dynamic or static.
     */
    private Boolean isDynamicConfig;

    /*
     * Configuration read-only or not.
     */
    private Boolean isReadOnly;

    /*
     * Configuration is pending restart or not.
     */
    private Boolean isConfigPendingRestart;

    /*
     * Configuration unit.
     */
    private String unit;

    /*
     * Configuration documentation link.
     */
    private String documentationLink;

    /**
     * Creates an instance of ConfigurationProperties class.
     */
    public ConfigurationProperties() {
    }

    /**
     * Get the value property: Value of the configuration. Required to update the configuration.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value of the configuration. Required to update the configuration.
     * 
     * @param value the value value to set.
     * @return the ConfigurationProperties object itself.
     */
    public ConfigurationProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the description property: Description of the configuration.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the defaultValue property: Default value of the configuration.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Get the dataType property: Data type of the configuration.
     * 
     * @return the dataType value.
     */
    public ConfigurationDataType dataType() {
        return this.dataType;
    }

    /**
     * Get the allowedValues property: Allowed values of the configuration.
     * 
     * @return the allowedValues value.
     */
    public String allowedValues() {
        return this.allowedValues;
    }

    /**
     * Get the source property: Source of the configuration. Required to update the configuration.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: Source of the configuration. Required to update the configuration.
     * 
     * @param source the source value to set.
     * @return the ConfigurationProperties object itself.
     */
    public ConfigurationProperties withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the isDynamicConfig property: Configuration dynamic or static.
     * 
     * @return the isDynamicConfig value.
     */
    public Boolean isDynamicConfig() {
        return this.isDynamicConfig;
    }

    /**
     * Get the isReadOnly property: Configuration read-only or not.
     * 
     * @return the isReadOnly value.
     */
    public Boolean isReadOnly() {
        return this.isReadOnly;
    }

    /**
     * Get the isConfigPendingRestart property: Configuration is pending restart or not.
     * 
     * @return the isConfigPendingRestart value.
     */
    public Boolean isConfigPendingRestart() {
        return this.isConfigPendingRestart;
    }

    /**
     * Get the unit property: Configuration unit.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the documentationLink property: Configuration documentation link.
     * 
     * @return the documentationLink value.
     */
    public String documentationLink() {
        return this.documentationLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationProperties.
     */
    public static ConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationProperties deserializedConfigurationProperties = new ConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedConfigurationProperties.value = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedConfigurationProperties.description = reader.getString();
                } else if ("defaultValue".equals(fieldName)) {
                    deserializedConfigurationProperties.defaultValue = reader.getString();
                } else if ("dataType".equals(fieldName)) {
                    deserializedConfigurationProperties.dataType = ConfigurationDataType.fromString(reader.getString());
                } else if ("allowedValues".equals(fieldName)) {
                    deserializedConfigurationProperties.allowedValues = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedConfigurationProperties.source = reader.getString();
                } else if ("isDynamicConfig".equals(fieldName)) {
                    deserializedConfigurationProperties.isDynamicConfig = reader.getNullable(JsonReader::getBoolean);
                } else if ("isReadOnly".equals(fieldName)) {
                    deserializedConfigurationProperties.isReadOnly = reader.getNullable(JsonReader::getBoolean);
                } else if ("isConfigPendingRestart".equals(fieldName)) {
                    deserializedConfigurationProperties.isConfigPendingRestart
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("unit".equals(fieldName)) {
                    deserializedConfigurationProperties.unit = reader.getString();
                } else if ("documentationLink".equals(fieldName)) {
                    deserializedConfigurationProperties.documentationLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationProperties;
        });
    }
}
