// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of a database.
 */
@Fluent
public final class DatabaseProperties implements JsonSerializable<DatabaseProperties> {
    /*
     * The charset of the database.
     */
    private String charset;

    /*
     * The collation of the database.
     */
    private String collation;

    /**
     * Creates an instance of DatabaseProperties class.
     */
    public DatabaseProperties() {
    }

    /**
     * Get the charset property: The charset of the database.
     * 
     * @return the charset value.
     */
    public String charset() {
        return this.charset;
    }

    /**
     * Set the charset property: The charset of the database.
     * 
     * @param charset the charset value to set.
     * @return the DatabaseProperties object itself.
     */
    public DatabaseProperties withCharset(String charset) {
        this.charset = charset;
        return this;
    }

    /**
     * Get the collation property: The collation of the database.
     * 
     * @return the collation value.
     */
    public String collation() {
        return this.collation;
    }

    /**
     * Set the collation property: The collation of the database.
     * 
     * @param collation the collation value to set.
     * @return the DatabaseProperties object itself.
     */
    public DatabaseProperties withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("charset", this.charset);
        jsonWriter.writeStringField("collation", this.collation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseProperties.
     */
    public static DatabaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseProperties deserializedDatabaseProperties = new DatabaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("charset".equals(fieldName)) {
                    deserializedDatabaseProperties.charset = reader.getString();
                } else if ("collation".equals(fieldName)) {
                    deserializedDatabaseProperties.collation = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseProperties;
        });
    }
}
