// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of a server firewall rule.
 */
@Fluent
public final class FirewallRuleProperties implements JsonSerializable<FirewallRuleProperties> {
    /*
     * The start IP address of the server firewall rule. Must be IPv4 format.
     */
    private String startIpAddress;

    /*
     * The end IP address of the server firewall rule. Must be IPv4 format.
     */
    private String endIpAddress;

    /**
     * Creates an instance of FirewallRuleProperties class.
     */
    public FirewallRuleProperties() {
    }

    /**
     * Get the startIpAddress property: The start IP address of the server firewall rule. Must be IPv4 format.
     * 
     * @return the startIpAddress value.
     */
    public String startIpAddress() {
        return this.startIpAddress;
    }

    /**
     * Set the startIpAddress property: The start IP address of the server firewall rule. Must be IPv4 format.
     * 
     * @param startIpAddress the startIpAddress value to set.
     * @return the FirewallRuleProperties object itself.
     */
    public FirewallRuleProperties withStartIpAddress(String startIpAddress) {
        this.startIpAddress = startIpAddress;
        return this;
    }

    /**
     * Get the endIpAddress property: The end IP address of the server firewall rule. Must be IPv4 format.
     * 
     * @return the endIpAddress value.
     */
    public String endIpAddress() {
        return this.endIpAddress;
    }

    /**
     * Set the endIpAddress property: The end IP address of the server firewall rule. Must be IPv4 format.
     * 
     * @param endIpAddress the endIpAddress value to set.
     * @return the FirewallRuleProperties object itself.
     */
    public FirewallRuleProperties withEndIpAddress(String endIpAddress) {
        this.endIpAddress = endIpAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (startIpAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property startIpAddress in model FirewallRuleProperties"));
        }
        if (endIpAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property endIpAddress in model FirewallRuleProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(FirewallRuleProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startIpAddress", this.startIpAddress);
        jsonWriter.writeStringField("endIpAddress", this.endIpAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallRuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallRuleProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FirewallRuleProperties.
     */
    public static FirewallRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallRuleProperties deserializedFirewallRuleProperties = new FirewallRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startIpAddress".equals(fieldName)) {
                    deserializedFirewallRuleProperties.startIpAddress = reader.getString();
                } else if ("endIpAddress".equals(fieldName)) {
                    deserializedFirewallRuleProperties.endIpAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallRuleProperties;
        });
    }
}
