// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Represents a logFile.
 */
@Fluent
public final class LogFileInner extends ProxyResource {
    /*
     * The properties of a logFile.
     */
    private LogFileProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of LogFileInner class.
     */
    public LogFileInner() {
    }

    /**
     * Get the innerProperties property: The properties of a logFile.
     * 
     * @return the innerProperties value.
     */
    private LogFileProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the createdTime property: Creation timestamp of the log file.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    /**
     * Set the createdTime property: Creation timestamp of the log file.
     * 
     * @param createdTime the createdTime value to set.
     * @return the LogFileInner object itself.
     */
    public LogFileInner withCreatedTime(OffsetDateTime createdTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withCreatedTime(createdTime);
        return this;
    }

    /**
     * Get the lastModifiedTime property: Last modified timestamp of the log file.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    /**
     * Set the lastModifiedTime property: Last modified timestamp of the log file.
     * 
     * @param lastModifiedTime the lastModifiedTime value to set.
     * @return the LogFileInner object itself.
     */
    public LogFileInner withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withLastModifiedTime(lastModifiedTime);
        return this;
    }

    /**
     * Get the sizeInKb property: The size in kb of the logFile.
     * 
     * @return the sizeInKb value.
     */
    public Long sizeInKb() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInKb();
    }

    /**
     * Set the sizeInKb property: The size in kb of the logFile.
     * 
     * @param sizeInKb the sizeInKb value to set.
     * @return the LogFileInner object itself.
     */
    public LogFileInner withSizeInKb(Long sizeInKb) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withSizeInKb(sizeInKb);
        return this;
    }

    /**
     * Get the type property: Type of the log file.
     * 
     * @return the type value.
     */
    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Type of the log file.
     * 
     * @param type the type value to set.
     * @return the LogFileInner object itself.
     */
    public LogFileInner withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the url property: The url to download the log file from.
     * 
     * @return the url value.
     */
    public String url() {
        return this.innerProperties() == null ? null : this.innerProperties().url();
    }

    /**
     * Set the url property: The url to download the log file from.
     * 
     * @param url the url value to set.
     * @return the LogFileInner object itself.
     */
    public LogFileInner withUrl(String url) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LogFileProperties();
        }
        this.innerProperties().withUrl(url);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogFileInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogFileInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogFileInner.
     */
    public static LogFileInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogFileInner deserializedLogFileInner = new LogFileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLogFileInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLogFileInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLogFileInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLogFileInner.innerProperties = LogFileProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedLogFileInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogFileInner;
        });
    }
}
