// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ExecutionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Response for the backup request.
 */
@Fluent
public final class LtrBackupOperationResponseProperties
    implements JsonSerializable<LtrBackupOperationResponseProperties> {
    /*
     * Size of datasource in bytes
     */
    private Long datasourceSizeInBytes;

    /*
     * Data transferred in bytes
     */
    private Long dataTransferredInBytes;

    /*
     * Name of Backup operation
     */
    private String backupName;

    /*
     * Metadata to be stored in RP. Store everything that will be required to perform a successful restore using this
     * Recovery point. e.g. Versions, DataFormat etc
     */
    private String backupMetadata;

    /*
     * Service-set extensible enum indicating the status of operation
     */
    private ExecutionStatus status;

    /*
     * Start time of the operation.
     */
    private OffsetDateTime startTime;

    /*
     * End time of the operation.
     */
    private OffsetDateTime endTime;

    /*
     * PercentageCompleted
     */
    private Double percentComplete;

    /*
     * The error code.
     */
    private String errorCode;

    /*
     * The error message.
     */
    private String errorMessage;

    /**
     * Creates an instance of LtrBackupOperationResponseProperties class.
     */
    public LtrBackupOperationResponseProperties() {
    }

    /**
     * Get the datasourceSizeInBytes property: Size of datasource in bytes.
     * 
     * @return the datasourceSizeInBytes value.
     */
    public Long datasourceSizeInBytes() {
        return this.datasourceSizeInBytes;
    }

    /**
     * Set the datasourceSizeInBytes property: Size of datasource in bytes.
     * 
     * @param datasourceSizeInBytes the datasourceSizeInBytes value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withDatasourceSizeInBytes(Long datasourceSizeInBytes) {
        this.datasourceSizeInBytes = datasourceSizeInBytes;
        return this;
    }

    /**
     * Get the dataTransferredInBytes property: Data transferred in bytes.
     * 
     * @return the dataTransferredInBytes value.
     */
    public Long dataTransferredInBytes() {
        return this.dataTransferredInBytes;
    }

    /**
     * Set the dataTransferredInBytes property: Data transferred in bytes.
     * 
     * @param dataTransferredInBytes the dataTransferredInBytes value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withDataTransferredInBytes(Long dataTransferredInBytes) {
        this.dataTransferredInBytes = dataTransferredInBytes;
        return this;
    }

    /**
     * Get the backupName property: Name of Backup operation.
     * 
     * @return the backupName value.
     */
    public String backupName() {
        return this.backupName;
    }

    /**
     * Set the backupName property: Name of Backup operation.
     * 
     * @param backupName the backupName value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    /**
     * Get the backupMetadata property: Metadata to be stored in RP. Store everything that will be required to perform a
     * successful restore using this Recovery point. e.g. Versions, DataFormat etc.
     * 
     * @return the backupMetadata value.
     */
    public String backupMetadata() {
        return this.backupMetadata;
    }

    /**
     * Set the backupMetadata property: Metadata to be stored in RP. Store everything that will be required to perform a
     * successful restore using this Recovery point. e.g. Versions, DataFormat etc.
     * 
     * @param backupMetadata the backupMetadata value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withBackupMetadata(String backupMetadata) {
        this.backupMetadata = backupMetadata;
        return this;
    }

    /**
     * Get the status property: Service-set extensible enum indicating the status of operation.
     * 
     * @return the status value.
     */
    public ExecutionStatus status() {
        return this.status;
    }

    /**
     * Set the status property: Service-set extensible enum indicating the status of operation.
     * 
     * @param status the status value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withStatus(ExecutionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the startTime property: Start time of the operation.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the operation.
     * 
     * @param startTime the startTime value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: End time of the operation.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time of the operation.
     * 
     * @param endTime the endTime value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the percentComplete property: PercentageCompleted.
     * 
     * @return the percentComplete value.
     */
    public Double percentComplete() {
        return this.percentComplete;
    }

    /**
     * Set the percentComplete property: PercentageCompleted.
     * 
     * @param percentComplete the percentComplete value to set.
     * @return the LtrBackupOperationResponseProperties object itself.
     */
    public LtrBackupOperationResponseProperties withPercentComplete(Double percentComplete) {
        this.percentComplete = percentComplete;
        return this;
    }

    /**
     * Get the errorCode property: The error code.
     * 
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Get the errorMessage property: The error message.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property status in model LtrBackupOperationResponseProperties"));
        }
        if (startTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property startTime in model LtrBackupOperationResponseProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LtrBackupOperationResponseProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeNumberField("datasourceSizeInBytes", this.datasourceSizeInBytes);
        jsonWriter.writeNumberField("dataTransferredInBytes", this.dataTransferredInBytes);
        jsonWriter.writeStringField("backupName", this.backupName);
        jsonWriter.writeStringField("backupMetadata", this.backupMetadata);
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeNumberField("percentComplete", this.percentComplete);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LtrBackupOperationResponseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LtrBackupOperationResponseProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LtrBackupOperationResponseProperties.
     */
    public static LtrBackupOperationResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LtrBackupOperationResponseProperties deserializedLtrBackupOperationResponseProperties
                = new LtrBackupOperationResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.status
                        = ExecutionStatus.fromString(reader.getString());
                } else if ("startTime".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("datasourceSizeInBytes".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.datasourceSizeInBytes
                        = reader.getNullable(JsonReader::getLong);
                } else if ("dataTransferredInBytes".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.dataTransferredInBytes
                        = reader.getNullable(JsonReader::getLong);
                } else if ("backupName".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.backupName = reader.getString();
                } else if ("backupMetadata".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.backupMetadata = reader.getString();
                } else if ("endTime".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("percentComplete".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.percentComplete
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("errorCode".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.errorCode = reader.getString();
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedLtrBackupOperationResponseProperties.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLtrBackupOperationResponseProperties;
        });
    }
}
