// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response for the LTR pre-backup API call.
 */
@Fluent
public final class LtrPreBackupResponseInner implements JsonSerializable<LtrPreBackupResponseInner> {
    /*
     * Additional Properties for the pre backup response
     */
    private LtrPreBackupResponseProperties innerProperties = new LtrPreBackupResponseProperties();

    /**
     * Creates an instance of LtrPreBackupResponseInner class.
     */
    public LtrPreBackupResponseInner() {
    }

    /**
     * Get the innerProperties property: Additional Properties for the pre backup response.
     * 
     * @return the innerProperties value.
     */
    private LtrPreBackupResponseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the numberOfContainers property: Number of storage containers the plugin will use during backup. More than
     * one containers may be used for size limitations, parallelism, or redundancy etc.
     * 
     * @return the numberOfContainers value.
     */
    public int numberOfContainers() {
        return this.innerProperties() == null ? 0 : this.innerProperties().numberOfContainers();
    }

    /**
     * Set the numberOfContainers property: Number of storage containers the plugin will use during backup. More than
     * one containers may be used for size limitations, parallelism, or redundancy etc.
     * 
     * @param numberOfContainers the numberOfContainers value to set.
     * @return the LtrPreBackupResponseInner object itself.
     */
    public LtrPreBackupResponseInner withNumberOfContainers(int numberOfContainers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrPreBackupResponseProperties();
        }
        this.innerProperties().withNumberOfContainers(numberOfContainers);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model LtrPreBackupResponseInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LtrPreBackupResponseInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LtrPreBackupResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LtrPreBackupResponseInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LtrPreBackupResponseInner.
     */
    public static LtrPreBackupResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LtrPreBackupResponseInner deserializedLtrPreBackupResponseInner = new LtrPreBackupResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedLtrPreBackupResponseInner.innerProperties
                        = LtrPreBackupResponseProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLtrPreBackupResponseInner;
        });
    }
}
