// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response for the pre-backup request.
 */
@Fluent
public final class LtrPreBackupResponseProperties implements JsonSerializable<LtrPreBackupResponseProperties> {
    /*
     * Number of storage containers the plugin will use during backup. More than one containers may be used for size
     * limitations, parallelism, or redundancy etc.
     */
    private int numberOfContainers;

    /**
     * Creates an instance of LtrPreBackupResponseProperties class.
     */
    public LtrPreBackupResponseProperties() {
    }

    /**
     * Get the numberOfContainers property: Number of storage containers the plugin will use during backup. More than
     * one containers may be used for size limitations, parallelism, or redundancy etc.
     * 
     * @return the numberOfContainers value.
     */
    public int numberOfContainers() {
        return this.numberOfContainers;
    }

    /**
     * Set the numberOfContainers property: Number of storage containers the plugin will use during backup. More than
     * one containers may be used for size limitations, parallelism, or redundancy etc.
     * 
     * @param numberOfContainers the numberOfContainers value to set.
     * @return the LtrPreBackupResponseProperties object itself.
     */
    public LtrPreBackupResponseProperties withNumberOfContainers(int numberOfContainers) {
        this.numberOfContainers = numberOfContainers;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("numberOfContainers", this.numberOfContainers);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LtrPreBackupResponseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LtrPreBackupResponseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LtrPreBackupResponseProperties.
     */
    public static LtrPreBackupResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LtrPreBackupResponseProperties deserializedLtrPreBackupResponseProperties
                = new LtrPreBackupResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("numberOfContainers".equals(fieldName)) {
                    deserializedLtrPreBackupResponseProperties.numberOfContainers = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLtrPreBackupResponseProperties;
        });
    }
}
