// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ExecutionStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Response for the LTR backup Operation API call.
 */
@Fluent
public final class LtrServerBackupOperationInner extends ProxyResource {
    /*
     * Long Term Retention Backup Operation Resource Properties
     */
    private LtrBackupOperationResponseProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of LtrServerBackupOperationInner class.
     */
    public LtrServerBackupOperationInner() {
    }

    /**
     * Get the innerProperties property: Long Term Retention Backup Operation Resource Properties.
     * 
     * @return the innerProperties value.
     */
    private LtrBackupOperationResponseProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the datasourceSizeInBytes property: Size of datasource in bytes.
     * 
     * @return the datasourceSizeInBytes value.
     */
    public Long datasourceSizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().datasourceSizeInBytes();
    }

    /**
     * Set the datasourceSizeInBytes property: Size of datasource in bytes.
     * 
     * @param datasourceSizeInBytes the datasourceSizeInBytes value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withDatasourceSizeInBytes(Long datasourceSizeInBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withDatasourceSizeInBytes(datasourceSizeInBytes);
        return this;
    }

    /**
     * Get the dataTransferredInBytes property: Data transferred in bytes.
     * 
     * @return the dataTransferredInBytes value.
     */
    public Long dataTransferredInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().dataTransferredInBytes();
    }

    /**
     * Set the dataTransferredInBytes property: Data transferred in bytes.
     * 
     * @param dataTransferredInBytes the dataTransferredInBytes value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withDataTransferredInBytes(Long dataTransferredInBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withDataTransferredInBytes(dataTransferredInBytes);
        return this;
    }

    /**
     * Get the backupName property: Name of Backup operation.
     * 
     * @return the backupName value.
     */
    public String backupName() {
        return this.innerProperties() == null ? null : this.innerProperties().backupName();
    }

    /**
     * Set the backupName property: Name of Backup operation.
     * 
     * @param backupName the backupName value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withBackupName(String backupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withBackupName(backupName);
        return this;
    }

    /**
     * Get the backupMetadata property: Metadata to be stored in RP. Store everything that will be required to perform a
     * successful restore using this Recovery point. e.g. Versions, DataFormat etc.
     * 
     * @return the backupMetadata value.
     */
    public String backupMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().backupMetadata();
    }

    /**
     * Set the backupMetadata property: Metadata to be stored in RP. Store everything that will be required to perform a
     * successful restore using this Recovery point. e.g. Versions, DataFormat etc.
     * 
     * @param backupMetadata the backupMetadata value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withBackupMetadata(String backupMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withBackupMetadata(backupMetadata);
        return this;
    }

    /**
     * Get the status property: Service-set extensible enum indicating the status of operation.
     * 
     * @return the status value.
     */
    public ExecutionStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Service-set extensible enum indicating the status of operation.
     * 
     * @param status the status value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withStatus(ExecutionStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the startTime property: Start time of the operation.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Set the startTime property: Start time of the operation.
     * 
     * @param startTime the startTime value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the endTime property: End time of the operation.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Set the endTime property: End time of the operation.
     * 
     * @param endTime the endTime value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    /**
     * Get the percentComplete property: PercentageCompleted.
     * 
     * @return the percentComplete value.
     */
    public Double percentComplete() {
        return this.innerProperties() == null ? null : this.innerProperties().percentComplete();
    }

    /**
     * Set the percentComplete property: PercentageCompleted.
     * 
     * @param percentComplete the percentComplete value to set.
     * @return the LtrServerBackupOperationInner object itself.
     */
    public LtrServerBackupOperationInner withPercentComplete(Double percentComplete) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LtrBackupOperationResponseProperties();
        }
        this.innerProperties().withPercentComplete(percentComplete);
        return this;
    }

    /**
     * Get the errorCode property: The error code.
     * 
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.innerProperties() == null ? null : this.innerProperties().errorCode();
    }

    /**
     * Get the errorMessage property: The error message.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().errorMessage();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LtrServerBackupOperationInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LtrServerBackupOperationInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LtrServerBackupOperationInner.
     */
    public static LtrServerBackupOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LtrServerBackupOperationInner deserializedLtrServerBackupOperationInner
                = new LtrServerBackupOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLtrServerBackupOperationInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLtrServerBackupOperationInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedLtrServerBackupOperationInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedLtrServerBackupOperationInner.innerProperties
                        = LtrBackupOperationResponseProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedLtrServerBackupOperationInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLtrServerBackupOperationInner;
        });
    }
}
