// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CancelEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbServerMetadata;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceDbEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationOption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDbsInTargetEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SourceType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.SslMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigrationEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutoverEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Migration resource properties.
 */
@Fluent
public final class MigrationResourceProperties implements JsonSerializable<MigrationResourceProperties> {
    /*
     * ID for migration, a GUID.
     */
    private String migrationId;

    /*
     * Current status of migration
     */
    private MigrationStatus currentStatus;

    /*
     * ResourceId of the private endpoint migration instance
     */
    private String migrationInstanceResourceId;

    /*
     * There are two types of migration modes Online and Offline
     */
    private MigrationMode migrationMode;

    /*
     * This indicates the supported Migration option for the migration
     */
    private MigrationOption migrationOption;

    /*
     * migration source server type : OnPremises, AWS, GCP, AzureVM, PostgreSQLSingleServer, AWS_RDS, AWS_AURORA,
     * AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB
     */
    private SourceType sourceType;

    /*
     * SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is VerifyFull and Prefer for other source
     * types
     */
    private SslMode sslMode;

    /*
     * Metadata of the source database server
     */
    private DbServerMetadata sourceDbServerMetadata;

    /*
     * Metadata of the target database server
     */
    private DbServerMetadata targetDbServerMetadata;

    /*
     * ResourceId of the source database server in case the sourceType is PostgreSQLSingleServer. For other source types
     * this should be ipaddress:port@username or hostname:port@username
     */
    private String sourceDbServerResourceId;

    /*
     * Source server fully qualified domain name (FQDN) or IP address. It is a optional value, if customer provide it,
     * migration service will always use it for connection
     */
    private String sourceDbServerFullyQualifiedDomainName;

    /*
     * ResourceId of the source database server
     */
    private String targetDbServerResourceId;

    /*
     * Target server fully qualified domain name (FQDN) or IP address. It is a optional value, if customer provide it,
     * migration service will always use it for connection
     */
    private String targetDbServerFullyQualifiedDomainName;

    /*
     * Migration secret parameters
     */
    private MigrationSecretParameters secretParameters;

    /*
     * Number of databases to migrate
     */
    private List<String> dbsToMigrate;

    /*
     * Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    private LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded;

    /*
     * Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the
     * migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    private OverwriteDbsInTargetEnum overwriteDbsInTarget;

    /*
     * Start time in UTC for migration window
     */
    private OffsetDateTime migrationWindowStartTimeInUtc;

    /*
     * End time in UTC for migration window
     */
    private OffsetDateTime migrationWindowEndTimeInUtc;

    /*
     * To migrate roles and permissions we need to send this flag as True
     */
    private MigrateRolesEnum migrateRoles;

    /*
     * Indicates whether the data migration should start right away
     */
    private StartDataMigrationEnum startDataMigration;

    /*
     * To trigger cutover for entire migration we need to send this flag as True
     */
    private TriggerCutoverEnum triggerCutover;

    /*
     * When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in
     * this array
     */
    private List<String> dbsToTriggerCutoverOn;

    /*
     * To trigger cancel for entire migration we need to send this flag as True
     */
    private CancelEnum cancel;

    /*
     * When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    private List<String> dbsToCancelMigrationOn;

    /**
     * Creates an instance of MigrationResourceProperties class.
     */
    public MigrationResourceProperties() {
    }

    /**
     * Get the migrationId property: ID for migration, a GUID.
     * 
     * @return the migrationId value.
     */
    public String migrationId() {
        return this.migrationId;
    }

    /**
     * Get the currentStatus property: Current status of migration.
     * 
     * @return the currentStatus value.
     */
    public MigrationStatus currentStatus() {
        return this.currentStatus;
    }

    /**
     * Get the migrationInstanceResourceId property: ResourceId of the private endpoint migration instance.
     * 
     * @return the migrationInstanceResourceId value.
     */
    public String migrationInstanceResourceId() {
        return this.migrationInstanceResourceId;
    }

    /**
     * Set the migrationInstanceResourceId property: ResourceId of the private endpoint migration instance.
     * 
     * @param migrationInstanceResourceId the migrationInstanceResourceId value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withMigrationInstanceResourceId(String migrationInstanceResourceId) {
        this.migrationInstanceResourceId = migrationInstanceResourceId;
        return this;
    }

    /**
     * Get the migrationMode property: There are two types of migration modes Online and Offline.
     * 
     * @return the migrationMode value.
     */
    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    /**
     * Set the migrationMode property: There are two types of migration modes Online and Offline.
     * 
     * @param migrationMode the migrationMode value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withMigrationMode(MigrationMode migrationMode) {
        this.migrationMode = migrationMode;
        return this;
    }

    /**
     * Get the migrationOption property: This indicates the supported Migration option for the migration.
     * 
     * @return the migrationOption value.
     */
    public MigrationOption migrationOption() {
        return this.migrationOption;
    }

    /**
     * Set the migrationOption property: This indicates the supported Migration option for the migration.
     * 
     * @param migrationOption the migrationOption value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withMigrationOption(MigrationOption migrationOption) {
        this.migrationOption = migrationOption;
        return this;
    }

    /**
     * Get the sourceType property: migration source server type : OnPremises, AWS, GCP, AzureVM,
     * PostgreSQLSingleServer, AWS_RDS, AWS_AURORA, AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB.
     * 
     * @return the sourceType value.
     */
    public SourceType sourceType() {
        return this.sourceType;
    }

    /**
     * Set the sourceType property: migration source server type : OnPremises, AWS, GCP, AzureVM,
     * PostgreSQLSingleServer, AWS_RDS, AWS_AURORA, AWS_EC2, GCP_CloudSQL, GCP_AlloyDB, GCP_Compute, or EDB.
     * 
     * @param sourceType the sourceType value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    /**
     * Get the sslMode property: SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is VerifyFull and
     * Prefer for other source types.
     * 
     * @return the sslMode value.
     */
    public SslMode sslMode() {
        return this.sslMode;
    }

    /**
     * Set the sslMode property: SSL modes for migration. Default SSL mode for PostgreSQLSingleServer is VerifyFull and
     * Prefer for other source types.
     * 
     * @param sslMode the sslMode value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withSslMode(SslMode sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    /**
     * Get the sourceDbServerMetadata property: Metadata of the source database server.
     * 
     * @return the sourceDbServerMetadata value.
     */
    public DbServerMetadata sourceDbServerMetadata() {
        return this.sourceDbServerMetadata;
    }

    /**
     * Get the targetDbServerMetadata property: Metadata of the target database server.
     * 
     * @return the targetDbServerMetadata value.
     */
    public DbServerMetadata targetDbServerMetadata() {
        return this.targetDbServerMetadata;
    }

    /**
     * Get the sourceDbServerResourceId property: ResourceId of the source database server in case the sourceType is
     * PostgreSQLSingleServer. For other source types this should be ipaddress:port&#064;username or
     * hostname:port&#064;username.
     * 
     * @return the sourceDbServerResourceId value.
     */
    public String sourceDbServerResourceId() {
        return this.sourceDbServerResourceId;
    }

    /**
     * Set the sourceDbServerResourceId property: ResourceId of the source database server in case the sourceType is
     * PostgreSQLSingleServer. For other source types this should be ipaddress:port&#064;username or
     * hostname:port&#064;username.
     * 
     * @param sourceDbServerResourceId the sourceDbServerResourceId value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withSourceDbServerResourceId(String sourceDbServerResourceId) {
        this.sourceDbServerResourceId = sourceDbServerResourceId;
        return this;
    }

    /**
     * Get the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @return the sourceDbServerFullyQualifiedDomainName value.
     */
    public String sourceDbServerFullyQualifiedDomainName() {
        return this.sourceDbServerFullyQualifiedDomainName;
    }

    /**
     * Set the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @param sourceDbServerFullyQualifiedDomainName the sourceDbServerFullyQualifiedDomainName value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties
        withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        this.sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName;
        return this;
    }

    /**
     * Get the targetDbServerResourceId property: ResourceId of the source database server.
     * 
     * @return the targetDbServerResourceId value.
     */
    public String targetDbServerResourceId() {
        return this.targetDbServerResourceId;
    }

    /**
     * Get the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @return the targetDbServerFullyQualifiedDomainName value.
     */
    public String targetDbServerFullyQualifiedDomainName() {
        return this.targetDbServerFullyQualifiedDomainName;
    }

    /**
     * Set the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @param targetDbServerFullyQualifiedDomainName the targetDbServerFullyQualifiedDomainName value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties
        withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        this.targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName;
        return this;
    }

    /**
     * Get the secretParameters property: Migration secret parameters.
     * 
     * @return the secretParameters value.
     */
    public MigrationSecretParameters secretParameters() {
        return this.secretParameters;
    }

    /**
     * Set the secretParameters property: Migration secret parameters.
     * 
     * @param secretParameters the secretParameters value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withSecretParameters(MigrationSecretParameters secretParameters) {
        this.secretParameters = secretParameters;
        return this;
    }

    /**
     * Get the dbsToMigrate property: Number of databases to migrate.
     * 
     * @return the dbsToMigrate value.
     */
    public List<String> dbsToMigrate() {
        return this.dbsToMigrate;
    }

    /**
     * Set the dbsToMigrate property: Number of databases to migrate.
     * 
     * @param dbsToMigrate the dbsToMigrate value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withDbsToMigrate(List<String> dbsToMigrate) {
        this.dbsToMigrate = dbsToMigrate;
        return this;
    }

    /**
     * Get the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
     * LogicalReplicationOnSourceDb, if needed.
     * 
     * @return the setupLogicalReplicationOnSourceDbIfNeeded value.
     */
    public LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.setupLogicalReplicationOnSourceDbIfNeeded;
    }

    /**
     * Set the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
     * LogicalReplicationOnSourceDb, if needed.
     * 
     * @param setupLogicalReplicationOnSourceDbIfNeeded the setupLogicalReplicationOnSourceDbIfNeeded value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withSetupLogicalReplicationOnSourceDbIfNeeded(
        LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded;
        return this;
    }

    /**
     * Get the overwriteDbsInTarget property: Indicates whether the databases on the target server can be overwritten,
     * if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the
     * database already exists.
     * 
     * @return the overwriteDbsInTarget value.
     */
    public OverwriteDbsInTargetEnum overwriteDbsInTarget() {
        return this.overwriteDbsInTarget;
    }

    /**
     * Set the overwriteDbsInTarget property: Indicates whether the databases on the target server can be overwritten,
     * if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the
     * database already exists.
     * 
     * @param overwriteDbsInTarget the overwriteDbsInTarget value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget) {
        this.overwriteDbsInTarget = overwriteDbsInTarget;
        return this;
    }

    /**
     * Get the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
     * 
     * @return the migrationWindowStartTimeInUtc value.
     */
    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.migrationWindowStartTimeInUtc;
    }

    /**
     * Set the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
     * 
     * @param migrationWindowStartTimeInUtc the migrationWindowStartTimeInUtc value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        this.migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc;
        return this;
    }

    /**
     * Get the migrationWindowEndTimeInUtc property: End time in UTC for migration window.
     * 
     * @return the migrationWindowEndTimeInUtc value.
     */
    public OffsetDateTime migrationWindowEndTimeInUtc() {
        return this.migrationWindowEndTimeInUtc;
    }

    /**
     * Set the migrationWindowEndTimeInUtc property: End time in UTC for migration window.
     * 
     * @param migrationWindowEndTimeInUtc the migrationWindowEndTimeInUtc value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withMigrationWindowEndTimeInUtc(OffsetDateTime migrationWindowEndTimeInUtc) {
        this.migrationWindowEndTimeInUtc = migrationWindowEndTimeInUtc;
        return this;
    }

    /**
     * Get the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
     * 
     * @return the migrateRoles value.
     */
    public MigrateRolesEnum migrateRoles() {
        return this.migrateRoles;
    }

    /**
     * Set the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
     * 
     * @param migrateRoles the migrateRoles value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withMigrateRoles(MigrateRolesEnum migrateRoles) {
        this.migrateRoles = migrateRoles;
        return this;
    }

    /**
     * Get the startDataMigration property: Indicates whether the data migration should start right away.
     * 
     * @return the startDataMigration value.
     */
    public StartDataMigrationEnum startDataMigration() {
        return this.startDataMigration;
    }

    /**
     * Set the startDataMigration property: Indicates whether the data migration should start right away.
     * 
     * @param startDataMigration the startDataMigration value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withStartDataMigration(StartDataMigrationEnum startDataMigration) {
        this.startDataMigration = startDataMigration;
        return this;
    }

    /**
     * Get the triggerCutover property: To trigger cutover for entire migration we need to send this flag as True.
     * 
     * @return the triggerCutover value.
     */
    public TriggerCutoverEnum triggerCutover() {
        return this.triggerCutover;
    }

    /**
     * Set the triggerCutover property: To trigger cutover for entire migration we need to send this flag as True.
     * 
     * @param triggerCutover the triggerCutover value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withTriggerCutover(TriggerCutoverEnum triggerCutover) {
        this.triggerCutover = triggerCutover;
        return this;
    }

    /**
     * Get the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases send
     * triggerCutover flag as True and database names in this array.
     * 
     * @return the dbsToTriggerCutoverOn value.
     */
    public List<String> dbsToTriggerCutoverOn() {
        return this.dbsToTriggerCutoverOn;
    }

    /**
     * Set the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases send
     * triggerCutover flag as True and database names in this array.
     * 
     * @param dbsToTriggerCutoverOn the dbsToTriggerCutoverOn value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        this.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
        return this;
    }

    /**
     * Get the cancel property: To trigger cancel for entire migration we need to send this flag as True.
     * 
     * @return the cancel value.
     */
    public CancelEnum cancel() {
        return this.cancel;
    }

    /**
     * Set the cancel property: To trigger cancel for entire migration we need to send this flag as True.
     * 
     * @param cancel the cancel value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withCancel(CancelEnum cancel) {
        this.cancel = cancel;
        return this;
    }

    /**
     * Get the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases send cancel flag
     * as True and database names in this array.
     * 
     * @return the dbsToCancelMigrationOn value.
     */
    public List<String> dbsToCancelMigrationOn() {
        return this.dbsToCancelMigrationOn;
    }

    /**
     * Set the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases send cancel flag
     * as True and database names in this array.
     * 
     * @param dbsToCancelMigrationOn the dbsToCancelMigrationOn value to set.
     * @return the MigrationResourceProperties object itself.
     */
    public MigrationResourceProperties withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        this.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (currentStatus() != null) {
            currentStatus().validate();
        }
        if (sourceDbServerMetadata() != null) {
            sourceDbServerMetadata().validate();
        }
        if (targetDbServerMetadata() != null) {
            targetDbServerMetadata().validate();
        }
        if (secretParameters() != null) {
            secretParameters().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("migrationInstanceResourceId", this.migrationInstanceResourceId);
        jsonWriter.writeStringField("migrationMode", this.migrationMode == null ? null : this.migrationMode.toString());
        jsonWriter.writeStringField("migrationOption",
            this.migrationOption == null ? null : this.migrationOption.toString());
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        jsonWriter.writeStringField("sslMode", this.sslMode == null ? null : this.sslMode.toString());
        jsonWriter.writeStringField("sourceDbServerResourceId", this.sourceDbServerResourceId);
        jsonWriter.writeStringField("sourceDbServerFullyQualifiedDomainName",
            this.sourceDbServerFullyQualifiedDomainName);
        jsonWriter.writeStringField("targetDbServerFullyQualifiedDomainName",
            this.targetDbServerFullyQualifiedDomainName);
        jsonWriter.writeJsonField("secretParameters", this.secretParameters);
        jsonWriter.writeArrayField("dbsToMigrate", this.dbsToMigrate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("setupLogicalReplicationOnSourceDbIfNeeded",
            this.setupLogicalReplicationOnSourceDbIfNeeded == null
                ? null
                : this.setupLogicalReplicationOnSourceDbIfNeeded.toString());
        jsonWriter.writeStringField("overwriteDbsInTarget",
            this.overwriteDbsInTarget == null ? null : this.overwriteDbsInTarget.toString());
        jsonWriter.writeStringField("migrationWindowStartTimeInUtc",
            this.migrationWindowStartTimeInUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowStartTimeInUtc));
        jsonWriter.writeStringField("migrationWindowEndTimeInUtc",
            this.migrationWindowEndTimeInUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowEndTimeInUtc));
        jsonWriter.writeStringField("migrateRoles", this.migrateRoles == null ? null : this.migrateRoles.toString());
        jsonWriter.writeStringField("startDataMigration",
            this.startDataMigration == null ? null : this.startDataMigration.toString());
        jsonWriter.writeStringField("triggerCutover",
            this.triggerCutover == null ? null : this.triggerCutover.toString());
        jsonWriter.writeArrayField("dbsToTriggerCutoverOn", this.dbsToTriggerCutoverOn,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cancel", this.cancel == null ? null : this.cancel.toString());
        jsonWriter.writeArrayField("dbsToCancelMigrationOn", this.dbsToCancelMigrationOn,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationResourceProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationResourceProperties.
     */
    public static MigrationResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationResourceProperties deserializedMigrationResourceProperties = new MigrationResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("migrationId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationId = reader.getString();
                } else if ("currentStatus".equals(fieldName)) {
                    deserializedMigrationResourceProperties.currentStatus = MigrationStatus.fromJson(reader);
                } else if ("migrationInstanceResourceId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationInstanceResourceId = reader.getString();
                } else if ("migrationMode".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationMode
                        = MigrationMode.fromString(reader.getString());
                } else if ("migrationOption".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationOption
                        = MigrationOption.fromString(reader.getString());
                } else if ("sourceType".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceType = SourceType.fromString(reader.getString());
                } else if ("sslMode".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sslMode = SslMode.fromString(reader.getString());
                } else if ("sourceDbServerMetadata".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceDbServerMetadata = DbServerMetadata.fromJson(reader);
                } else if ("targetDbServerMetadata".equals(fieldName)) {
                    deserializedMigrationResourceProperties.targetDbServerMetadata = DbServerMetadata.fromJson(reader);
                } else if ("sourceDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceDbServerResourceId = reader.getString();
                } else if ("sourceDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourceProperties.sourceDbServerFullyQualifiedDomainName = reader.getString();
                } else if ("targetDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationResourceProperties.targetDbServerResourceId = reader.getString();
                } else if ("targetDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourceProperties.targetDbServerFullyQualifiedDomainName = reader.getString();
                } else if ("secretParameters".equals(fieldName)) {
                    deserializedMigrationResourceProperties.secretParameters
                        = MigrationSecretParameters.fromJson(reader);
                } else if ("dbsToMigrate".equals(fieldName)) {
                    List<String> dbsToMigrate = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrationResourceProperties.dbsToMigrate = dbsToMigrate;
                } else if ("setupLogicalReplicationOnSourceDbIfNeeded".equals(fieldName)) {
                    deserializedMigrationResourceProperties.setupLogicalReplicationOnSourceDbIfNeeded
                        = LogicalReplicationOnSourceDbEnum.fromString(reader.getString());
                } else if ("overwriteDbsInTarget".equals(fieldName)) {
                    deserializedMigrationResourceProperties.overwriteDbsInTarget
                        = OverwriteDbsInTargetEnum.fromString(reader.getString());
                } else if ("migrationWindowStartTimeInUtc".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationWindowStartTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("migrationWindowEndTimeInUtc".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrationWindowEndTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("migrateRoles".equals(fieldName)) {
                    deserializedMigrationResourceProperties.migrateRoles
                        = MigrateRolesEnum.fromString(reader.getString());
                } else if ("startDataMigration".equals(fieldName)) {
                    deserializedMigrationResourceProperties.startDataMigration
                        = StartDataMigrationEnum.fromString(reader.getString());
                } else if ("triggerCutover".equals(fieldName)) {
                    deserializedMigrationResourceProperties.triggerCutover
                        = TriggerCutoverEnum.fromString(reader.getString());
                } else if ("dbsToTriggerCutoverOn".equals(fieldName)) {
                    List<String> dbsToTriggerCutoverOn = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrationResourceProperties.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
                } else if ("cancel".equals(fieldName)) {
                    deserializedMigrationResourceProperties.cancel = CancelEnum.fromString(reader.getString());
                } else if ("dbsToCancelMigrationOn".equals(fieldName)) {
                    List<String> dbsToCancelMigrationOn = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrationResourceProperties.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationResourceProperties;
        });
    }
}
