// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CancelEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceDbEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDbsInTargetEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigrationEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutoverEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Migration resource properties for patch.
 */
@Fluent
public final class MigrationResourcePropertiesForPatch
    implements JsonSerializable<MigrationResourcePropertiesForPatch> {
    /*
     * ResourceId of the source database server
     */
    private String sourceDbServerResourceId;

    /*
     * Source server fully qualified domain name (FQDN) or IP address. It is a optional value, if customer provide it,
     * migration service will always use it for connection
     */
    private String sourceDbServerFullyQualifiedDomainName;

    /*
     * Target server fully qualified domain name (FQDN) or IP address. It is a optional value, if customer provide it,
     * migration service will always use it for connection
     */
    private String targetDbServerFullyQualifiedDomainName;

    /*
     * Migration secret parameters
     */
    private MigrationSecretParameters secretParameters;

    /*
     * Number of databases to migrate
     */
    private List<String> dbsToMigrate;

    /*
     * Indicates whether to setup LogicalReplicationOnSourceDb, if needed
     */
    private LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded;

    /*
     * Indicates whether the databases on the target server can be overwritten, if already present. If set to False, the
     * migration workflow will wait for a confirmation, if it detects that the database already exists.
     */
    private OverwriteDbsInTargetEnum overwriteDbsInTarget;

    /*
     * Start time in UTC for migration window
     */
    private OffsetDateTime migrationWindowStartTimeInUtc;

    /*
     * To migrate roles and permissions we need to send this flag as True
     */
    private MigrateRolesEnum migrateRoles;

    /*
     * Indicates whether the data migration should start right away
     */
    private StartDataMigrationEnum startDataMigration;

    /*
     * To trigger cutover for entire migration we need to send this flag as True
     */
    private TriggerCutoverEnum triggerCutover;

    /*
     * When you want to trigger cutover for specific databases send triggerCutover flag as True and database names in
     * this array
     */
    private List<String> dbsToTriggerCutoverOn;

    /*
     * To trigger cancel for entire migration we need to send this flag as True
     */
    private CancelEnum cancel;

    /*
     * When you want to trigger cancel for specific databases send cancel flag as True and database names in this array
     */
    private List<String> dbsToCancelMigrationOn;

    /*
     * There are two types of migration modes Online and Offline
     */
    private MigrationMode migrationMode;

    /**
     * Creates an instance of MigrationResourcePropertiesForPatch class.
     */
    public MigrationResourcePropertiesForPatch() {
    }

    /**
     * Get the sourceDbServerResourceId property: ResourceId of the source database server.
     * 
     * @return the sourceDbServerResourceId value.
     */
    public String sourceDbServerResourceId() {
        return this.sourceDbServerResourceId;
    }

    /**
     * Set the sourceDbServerResourceId property: ResourceId of the source database server.
     * 
     * @param sourceDbServerResourceId the sourceDbServerResourceId value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withSourceDbServerResourceId(String sourceDbServerResourceId) {
        this.sourceDbServerResourceId = sourceDbServerResourceId;
        return this;
    }

    /**
     * Get the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @return the sourceDbServerFullyQualifiedDomainName value.
     */
    public String sourceDbServerFullyQualifiedDomainName() {
        return this.sourceDbServerFullyQualifiedDomainName;
    }

    /**
     * Set the sourceDbServerFullyQualifiedDomainName property: Source server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @param sourceDbServerFullyQualifiedDomainName the sourceDbServerFullyQualifiedDomainName value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch
        withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        this.sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName;
        return this;
    }

    /**
     * Get the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @return the targetDbServerFullyQualifiedDomainName value.
     */
    public String targetDbServerFullyQualifiedDomainName() {
        return this.targetDbServerFullyQualifiedDomainName;
    }

    /**
     * Set the targetDbServerFullyQualifiedDomainName property: Target server fully qualified domain name (FQDN) or IP
     * address. It is a optional value, if customer provide it, migration service will always use it for connection.
     * 
     * @param targetDbServerFullyQualifiedDomainName the targetDbServerFullyQualifiedDomainName value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch
        withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        this.targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName;
        return this;
    }

    /**
     * Get the secretParameters property: Migration secret parameters.
     * 
     * @return the secretParameters value.
     */
    public MigrationSecretParameters secretParameters() {
        return this.secretParameters;
    }

    /**
     * Set the secretParameters property: Migration secret parameters.
     * 
     * @param secretParameters the secretParameters value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withSecretParameters(MigrationSecretParameters secretParameters) {
        this.secretParameters = secretParameters;
        return this;
    }

    /**
     * Get the dbsToMigrate property: Number of databases to migrate.
     * 
     * @return the dbsToMigrate value.
     */
    public List<String> dbsToMigrate() {
        return this.dbsToMigrate;
    }

    /**
     * Set the dbsToMigrate property: Number of databases to migrate.
     * 
     * @param dbsToMigrate the dbsToMigrate value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withDbsToMigrate(List<String> dbsToMigrate) {
        this.dbsToMigrate = dbsToMigrate;
        return this;
    }

    /**
     * Get the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
     * LogicalReplicationOnSourceDb, if needed.
     * 
     * @return the setupLogicalReplicationOnSourceDbIfNeeded value.
     */
    public LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.setupLogicalReplicationOnSourceDbIfNeeded;
    }

    /**
     * Set the setupLogicalReplicationOnSourceDbIfNeeded property: Indicates whether to setup
     * LogicalReplicationOnSourceDb, if needed.
     * 
     * @param setupLogicalReplicationOnSourceDbIfNeeded the setupLogicalReplicationOnSourceDbIfNeeded value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withSetupLogicalReplicationOnSourceDbIfNeeded(
        LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded;
        return this;
    }

    /**
     * Get the overwriteDbsInTarget property: Indicates whether the databases on the target server can be overwritten,
     * if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the
     * database already exists.
     * 
     * @return the overwriteDbsInTarget value.
     */
    public OverwriteDbsInTargetEnum overwriteDbsInTarget() {
        return this.overwriteDbsInTarget;
    }

    /**
     * Set the overwriteDbsInTarget property: Indicates whether the databases on the target server can be overwritten,
     * if already present. If set to False, the migration workflow will wait for a confirmation, if it detects that the
     * database already exists.
     * 
     * @param overwriteDbsInTarget the overwriteDbsInTarget value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget) {
        this.overwriteDbsInTarget = overwriteDbsInTarget;
        return this;
    }

    /**
     * Get the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
     * 
     * @return the migrationWindowStartTimeInUtc value.
     */
    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.migrationWindowStartTimeInUtc;
    }

    /**
     * Set the migrationWindowStartTimeInUtc property: Start time in UTC for migration window.
     * 
     * @param migrationWindowStartTimeInUtc the migrationWindowStartTimeInUtc value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch
        withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        this.migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc;
        return this;
    }

    /**
     * Get the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
     * 
     * @return the migrateRoles value.
     */
    public MigrateRolesEnum migrateRoles() {
        return this.migrateRoles;
    }

    /**
     * Set the migrateRoles property: To migrate roles and permissions we need to send this flag as True.
     * 
     * @param migrateRoles the migrateRoles value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withMigrateRoles(MigrateRolesEnum migrateRoles) {
        this.migrateRoles = migrateRoles;
        return this;
    }

    /**
     * Get the startDataMigration property: Indicates whether the data migration should start right away.
     * 
     * @return the startDataMigration value.
     */
    public StartDataMigrationEnum startDataMigration() {
        return this.startDataMigration;
    }

    /**
     * Set the startDataMigration property: Indicates whether the data migration should start right away.
     * 
     * @param startDataMigration the startDataMigration value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withStartDataMigration(StartDataMigrationEnum startDataMigration) {
        this.startDataMigration = startDataMigration;
        return this;
    }

    /**
     * Get the triggerCutover property: To trigger cutover for entire migration we need to send this flag as True.
     * 
     * @return the triggerCutover value.
     */
    public TriggerCutoverEnum triggerCutover() {
        return this.triggerCutover;
    }

    /**
     * Set the triggerCutover property: To trigger cutover for entire migration we need to send this flag as True.
     * 
     * @param triggerCutover the triggerCutover value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withTriggerCutover(TriggerCutoverEnum triggerCutover) {
        this.triggerCutover = triggerCutover;
        return this;
    }

    /**
     * Get the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases send
     * triggerCutover flag as True and database names in this array.
     * 
     * @return the dbsToTriggerCutoverOn value.
     */
    public List<String> dbsToTriggerCutoverOn() {
        return this.dbsToTriggerCutoverOn;
    }

    /**
     * Set the dbsToTriggerCutoverOn property: When you want to trigger cutover for specific databases send
     * triggerCutover flag as True and database names in this array.
     * 
     * @param dbsToTriggerCutoverOn the dbsToTriggerCutoverOn value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        this.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
        return this;
    }

    /**
     * Get the cancel property: To trigger cancel for entire migration we need to send this flag as True.
     * 
     * @return the cancel value.
     */
    public CancelEnum cancel() {
        return this.cancel;
    }

    /**
     * Set the cancel property: To trigger cancel for entire migration we need to send this flag as True.
     * 
     * @param cancel the cancel value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withCancel(CancelEnum cancel) {
        this.cancel = cancel;
        return this;
    }

    /**
     * Get the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases send cancel flag
     * as True and database names in this array.
     * 
     * @return the dbsToCancelMigrationOn value.
     */
    public List<String> dbsToCancelMigrationOn() {
        return this.dbsToCancelMigrationOn;
    }

    /**
     * Set the dbsToCancelMigrationOn property: When you want to trigger cancel for specific databases send cancel flag
     * as True and database names in this array.
     * 
     * @param dbsToCancelMigrationOn the dbsToCancelMigrationOn value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        this.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
        return this;
    }

    /**
     * Get the migrationMode property: There are two types of migration modes Online and Offline.
     * 
     * @return the migrationMode value.
     */
    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    /**
     * Set the migrationMode property: There are two types of migration modes Online and Offline.
     * 
     * @param migrationMode the migrationMode value to set.
     * @return the MigrationResourcePropertiesForPatch object itself.
     */
    public MigrationResourcePropertiesForPatch withMigrationMode(MigrationMode migrationMode) {
        this.migrationMode = migrationMode;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (secretParameters() != null) {
            secretParameters().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceDbServerResourceId", this.sourceDbServerResourceId);
        jsonWriter.writeStringField("sourceDbServerFullyQualifiedDomainName",
            this.sourceDbServerFullyQualifiedDomainName);
        jsonWriter.writeStringField("targetDbServerFullyQualifiedDomainName",
            this.targetDbServerFullyQualifiedDomainName);
        jsonWriter.writeJsonField("secretParameters", this.secretParameters);
        jsonWriter.writeArrayField("dbsToMigrate", this.dbsToMigrate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("setupLogicalReplicationOnSourceDbIfNeeded",
            this.setupLogicalReplicationOnSourceDbIfNeeded == null
                ? null
                : this.setupLogicalReplicationOnSourceDbIfNeeded.toString());
        jsonWriter.writeStringField("overwriteDbsInTarget",
            this.overwriteDbsInTarget == null ? null : this.overwriteDbsInTarget.toString());
        jsonWriter.writeStringField("migrationWindowStartTimeInUtc",
            this.migrationWindowStartTimeInUtc == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowStartTimeInUtc));
        jsonWriter.writeStringField("migrateRoles", this.migrateRoles == null ? null : this.migrateRoles.toString());
        jsonWriter.writeStringField("startDataMigration",
            this.startDataMigration == null ? null : this.startDataMigration.toString());
        jsonWriter.writeStringField("triggerCutover",
            this.triggerCutover == null ? null : this.triggerCutover.toString());
        jsonWriter.writeArrayField("dbsToTriggerCutoverOn", this.dbsToTriggerCutoverOn,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cancel", this.cancel == null ? null : this.cancel.toString());
        jsonWriter.writeArrayField("dbsToCancelMigrationOn", this.dbsToCancelMigrationOn,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("migrationMode", this.migrationMode == null ? null : this.migrationMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrationResourcePropertiesForPatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrationResourcePropertiesForPatch if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrationResourcePropertiesForPatch.
     */
    public static MigrationResourcePropertiesForPatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrationResourcePropertiesForPatch deserializedMigrationResourcePropertiesForPatch
                = new MigrationResourcePropertiesForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.sourceDbServerResourceId = reader.getString();
                } else if ("sourceDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.sourceDbServerFullyQualifiedDomainName
                        = reader.getString();
                } else if ("targetDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.targetDbServerFullyQualifiedDomainName
                        = reader.getString();
                } else if ("secretParameters".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.secretParameters
                        = MigrationSecretParameters.fromJson(reader);
                } else if ("dbsToMigrate".equals(fieldName)) {
                    List<String> dbsToMigrate = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrationResourcePropertiesForPatch.dbsToMigrate = dbsToMigrate;
                } else if ("setupLogicalReplicationOnSourceDbIfNeeded".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.setupLogicalReplicationOnSourceDbIfNeeded
                        = LogicalReplicationOnSourceDbEnum.fromString(reader.getString());
                } else if ("overwriteDbsInTarget".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.overwriteDbsInTarget
                        = OverwriteDbsInTargetEnum.fromString(reader.getString());
                } else if ("migrationWindowStartTimeInUtc".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.migrationWindowStartTimeInUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("migrateRoles".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.migrateRoles
                        = MigrateRolesEnum.fromString(reader.getString());
                } else if ("startDataMigration".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.startDataMigration
                        = StartDataMigrationEnum.fromString(reader.getString());
                } else if ("triggerCutover".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.triggerCutover
                        = TriggerCutoverEnum.fromString(reader.getString());
                } else if ("dbsToTriggerCutoverOn".equals(fieldName)) {
                    List<String> dbsToTriggerCutoverOn = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrationResourcePropertiesForPatch.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
                } else if ("cancel".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.cancel = CancelEnum.fromString(reader.getString());
                } else if ("dbsToCancelMigrationOn".equals(fieldName)) {
                    List<String> dbsToCancelMigrationOn = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrationResourcePropertiesForPatch.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
                } else if ("migrationMode".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.migrationMode
                        = MigrationMode.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrationResourcePropertiesForPatch;
        });
    }
}
