// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CheckNameAvailabilityReason;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CheckNameAvailabilityResponse;
import java.io.IOException;

/**
 * Represents a resource name availability.
 */
@Fluent
public final class NameAvailabilityInner extends CheckNameAvailabilityResponse {
    /*
     * name of the PostgreSQL server.
     */
    private String name;

    /*
     * type of the server
     */
    private String type;

    /**
     * Creates an instance of NameAvailabilityInner class.
     */
    public NameAvailabilityInner() {
    }

    /**
     * Get the name property: name of the PostgreSQL server.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: type of the server.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NameAvailabilityInner withNameAvailable(Boolean nameAvailable) {
        super.withNameAvailable(nameAvailable);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NameAvailabilityInner withReason(CheckNameAvailabilityReason reason) {
        super.withReason(reason);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NameAvailabilityInner withMessage(String message) {
        super.withMessage(message);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("nameAvailable", nameAvailable());
        jsonWriter.writeStringField("reason", reason() == null ? null : reason().toString());
        jsonWriter.writeStringField("message", message());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NameAvailabilityInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NameAvailabilityInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NameAvailabilityInner.
     */
    public static NameAvailabilityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NameAvailabilityInner deserializedNameAvailabilityInner = new NameAvailabilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nameAvailable".equals(fieldName)) {
                    deserializedNameAvailabilityInner.withNameAvailable(reader.getNullable(JsonReader::getBoolean));
                } else if ("reason".equals(fieldName)) {
                    deserializedNameAvailabilityInner
                        .withReason(CheckNameAvailabilityReason.fromString(reader.getString()));
                } else if ("message".equals(fieldName)) {
                    deserializedNameAvailabilityInner.withMessage(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedNameAvailabilityInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNameAvailabilityInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNameAvailabilityInner;
        });
    }
}
