// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Origin;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Server backup properties.
 */
@Fluent
public final class ServerBackupInner extends ProxyResource {
    /*
     * The properties of a server backup.
     */
    private ServerBackupProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerBackupInner class.
     */
    public ServerBackupInner() {
    }

    /**
     * Get the innerProperties property: The properties of a server backup.
     * 
     * @return the innerProperties value.
     */
    private ServerBackupProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the backupType property: Backup type.
     * 
     * @return the backupType value.
     */
    public Origin backupType() {
        return this.innerProperties() == null ? null : this.innerProperties().backupType();
    }

    /**
     * Set the backupType property: Backup type.
     * 
     * @param backupType the backupType value to set.
     * @return the ServerBackupInner object itself.
     */
    public ServerBackupInner withBackupType(Origin backupType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerBackupProperties();
        }
        this.innerProperties().withBackupType(backupType);
        return this;
    }

    /**
     * Get the completedTime property: Backup completed time (ISO8601 format).
     * 
     * @return the completedTime value.
     */
    public OffsetDateTime completedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().completedTime();
    }

    /**
     * Set the completedTime property: Backup completed time (ISO8601 format).
     * 
     * @param completedTime the completedTime value to set.
     * @return the ServerBackupInner object itself.
     */
    public ServerBackupInner withCompletedTime(OffsetDateTime completedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerBackupProperties();
        }
        this.innerProperties().withCompletedTime(completedTime);
        return this;
    }

    /**
     * Get the source property: Backup source.
     * 
     * @return the source value.
     */
    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: Backup source.
     * 
     * @param source the source value to set.
     * @return the ServerBackupInner object itself.
     */
    public ServerBackupInner withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerBackupProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerBackupInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerBackupInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerBackupInner.
     */
    public static ServerBackupInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerBackupInner deserializedServerBackupInner = new ServerBackupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerBackupInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerBackupInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerBackupInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerBackupInner.innerProperties = ServerBackupProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedServerBackupInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerBackupInner;
        });
    }
}
