// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Origin;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The properties of a server backup.
 */
@Fluent
public final class ServerBackupProperties implements JsonSerializable<ServerBackupProperties> {
    /*
     * Backup type.
     */
    private Origin backupType;

    /*
     * Backup completed time (ISO8601 format).
     */
    private OffsetDateTime completedTime;

    /*
     * Backup source
     */
    private String source;

    /**
     * Creates an instance of ServerBackupProperties class.
     */
    public ServerBackupProperties() {
    }

    /**
     * Get the backupType property: Backup type.
     * 
     * @return the backupType value.
     */
    public Origin backupType() {
        return this.backupType;
    }

    /**
     * Set the backupType property: Backup type.
     * 
     * @param backupType the backupType value to set.
     * @return the ServerBackupProperties object itself.
     */
    public ServerBackupProperties withBackupType(Origin backupType) {
        this.backupType = backupType;
        return this;
    }

    /**
     * Get the completedTime property: Backup completed time (ISO8601 format).
     * 
     * @return the completedTime value.
     */
    public OffsetDateTime completedTime() {
        return this.completedTime;
    }

    /**
     * Set the completedTime property: Backup completed time (ISO8601 format).
     * 
     * @param completedTime the completedTime value to set.
     * @return the ServerBackupProperties object itself.
     */
    public ServerBackupProperties withCompletedTime(OffsetDateTime completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    /**
     * Get the source property: Backup source.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: Backup source.
     * 
     * @param source the source value to set.
     * @return the ServerBackupProperties object itself.
     */
    public ServerBackupProperties withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("backupType", this.backupType == null ? null : this.backupType.toString());
        jsonWriter.writeStringField("completedTime",
            this.completedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.completedTime));
        jsonWriter.writeStringField("source", this.source);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerBackupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerBackupProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerBackupProperties.
     */
    public static ServerBackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerBackupProperties deserializedServerBackupProperties = new ServerBackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backupType".equals(fieldName)) {
                    deserializedServerBackupProperties.backupType = Origin.fromString(reader.getString());
                } else if ("completedTime".equals(fieldName)) {
                    deserializedServerBackupProperties.completedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("source".equals(fieldName)) {
                    deserializedServerBackupProperties.source = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerBackupProperties;
        });
    }
}
