// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Sku;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import com.azure.resourcemanager.postgresqlflexibleserver.models.UserAssignedIdentity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Represents a server.
 */
@Fluent
public final class ServerInner extends Resource {
    /*
     * The SKU (pricing tier) of the server.
     */
    private Sku sku;

    /*
     * Describes the identity of the application.
     */
    private UserAssignedIdentity identity;

    /*
     * Properties of the server.
     */
    private ServerProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerInner class.
     */
    public ServerInner() {
    }

    /**
     * Get the sku property: The SKU (pricing tier) of the server.
     * 
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU (pricing tier) of the server.
     * 
     * @param sku the sku value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the identity property: Describes the identity of the application.
     * 
     * @return the identity value.
     */
    public UserAssignedIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Describes the identity of the application.
     * 
     * @param identity the identity value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withIdentity(UserAssignedIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the server.
     * 
     * @return the innerProperties value.
     */
    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ServerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is being created (and is required for creation).
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    /**
     * Set the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is being created (and is required for creation).
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    /**
     * Get the version property: PostgreSQL Server version.
     * 
     * @return the version value.
     */
    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    /**
     * Set the version property: PostgreSQL Server version.
     * 
     * @param version the version value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    /**
     * Get the minorVersion property: The minor version of the server.
     * 
     * @return the minorVersion value.
     */
    public String minorVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minorVersion();
    }

    /**
     * Get the state property: A state of a server that is visible to user.
     * 
     * @return the state value.
     */
    public ServerState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of a server.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    /**
     * Get the storage property: Storage properties of a server.
     * 
     * @return the storage value.
     */
    public Storage storage() {
        return this.innerProperties() == null ? null : this.innerProperties().storage();
    }

    /**
     * Set the storage property: Storage properties of a server.
     * 
     * @param storage the storage value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withStorage(Storage storage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withStorage(storage);
        return this;
    }

    /**
     * Get the authConfig property: AuthConfig properties of a server.
     * 
     * @return the authConfig value.
     */
    public AuthConfig authConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().authConfig();
    }

    /**
     * Set the authConfig property: AuthConfig properties of a server.
     * 
     * @param authConfig the authConfig value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAuthConfig(AuthConfig authConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAuthConfig(authConfig);
        return this;
    }

    /**
     * Get the dataEncryption property: Data encryption properties of a server.
     * 
     * @return the dataEncryption value.
     */
    public DataEncryption dataEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().dataEncryption();
    }

    /**
     * Set the dataEncryption property: Data encryption properties of a server.
     * 
     * @param dataEncryption the dataEncryption value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withDataEncryption(DataEncryption dataEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withDataEncryption(dataEncryption);
        return this;
    }

    /**
     * Get the backup property: Backup properties of a server.
     * 
     * @return the backup value.
     */
    public Backup backup() {
        return this.innerProperties() == null ? null : this.innerProperties().backup();
    }

    /**
     * Set the backup property: Backup properties of a server.
     * 
     * @param backup the backup value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withBackup(Backup backup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withBackup(backup);
        return this;
    }

    /**
     * Get the network property: Network properties of a server. This Network property is required to be passed only in
     * case you want the server to be Private access server.
     * 
     * @return the network value.
     */
    public Network network() {
        return this.innerProperties() == null ? null : this.innerProperties().network();
    }

    /**
     * Set the network property: Network properties of a server. This Network property is required to be passed only in
     * case you want the server to be Private access server.
     * 
     * @param network the network value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withNetwork(Network network) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withNetwork(network);
        return this;
    }

    /**
     * Get the highAvailability property: High availability properties of a server.
     * 
     * @return the highAvailability value.
     */
    public HighAvailability highAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailability();
    }

    /**
     * Set the highAvailability property: High availability properties of a server.
     * 
     * @param highAvailability the highAvailability value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withHighAvailability(HighAvailability highAvailability) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withHighAvailability(highAvailability);
        return this;
    }

    /**
     * Get the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @return the maintenanceWindow value.
     */
    public MaintenanceWindow maintenanceWindow() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceWindow();
    }

    /**
     * Set the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @param maintenanceWindow the maintenanceWindow value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    /**
     * Get the sourceServerResourceId property: The source server resource ID to restore from. It's required when
     * 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned
     * only for Replica server.
     * 
     * @return the sourceServerResourceId value.
     */
    public String sourceServerResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceServerResourceId();
    }

    /**
     * Set the sourceServerResourceId property: The source server resource ID to restore from. It's required when
     * 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned
     * only for Replica server.
     * 
     * @param sourceServerResourceId the sourceServerResourceId value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withSourceServerResourceId(String sourceServerResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withSourceServerResourceId(sourceServerResourceId);
        return this;
    }

    /**
     * Get the pointInTimeUtc property: Restore point creation time (ISO8601 format), specifying the time to restore
     * from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'.
     * 
     * @return the pointInTimeUtc value.
     */
    public OffsetDateTime pointInTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().pointInTimeUtc();
    }

    /**
     * Set the pointInTimeUtc property: Restore point creation time (ISO8601 format), specifying the time to restore
     * from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'.
     * 
     * @param pointInTimeUtc the pointInTimeUtc value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withPointInTimeUtc(OffsetDateTime pointInTimeUtc) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPointInTimeUtc(pointInTimeUtc);
        return this;
    }

    /**
     * Get the availabilityZone property: availability zone information of the server.
     * 
     * @return the availabilityZone value.
     */
    public String availabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZone();
    }

    /**
     * Set the availabilityZone property: availability zone information of the server.
     * 
     * @param availabilityZone the availabilityZone value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withAvailabilityZone(String availabilityZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAvailabilityZone(availabilityZone);
        return this;
    }

    /**
     * Get the replicationRole property: Replication role of the server.
     * 
     * @return the replicationRole value.
     */
    public ReplicationRole replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    /**
     * Set the replicationRole property: Replication role of the server.
     * 
     * @param replicationRole the replicationRole value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withReplicationRole(ReplicationRole replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    /**
     * Get the replicaCapacity property: Replicas allowed for a server.
     * 
     * @return the replicaCapacity value.
     */
    public Integer replicaCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCapacity();
    }

    /**
     * Get the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @return the replica value.
     */
    public Replica replica() {
        return this.innerProperties() == null ? null : this.innerProperties().replica();
    }

    /**
     * Set the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @param replica the replica value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withReplica(Replica replica) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplica(replica);
        return this;
    }

    /**
     * Get the createMode property: The mode to create a new PostgreSQL server.
     * 
     * @return the createMode value.
     */
    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    /**
     * Set the createMode property: The mode to create a new PostgreSQL server.
     * 
     * @param createMode the createMode value to set.
     * @return the ServerInner object itself.
     */
    public ServerInner withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections associated with the specified
     * resource.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerInner.
     */
    public static ServerInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerInner deserializedServerInner = new ServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedServerInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerInner.withTags(tags);
                } else if ("sku".equals(fieldName)) {
                    deserializedServerInner.sku = Sku.fromJson(reader);
                } else if ("identity".equals(fieldName)) {
                    deserializedServerInner.identity = UserAssignedIdentity.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedServerInner.innerProperties = ServerProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedServerInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerInner;
        });
    }
}
