// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The properties of a server.
 */
@Fluent
public final class ServerProperties implements JsonSerializable<ServerProperties> {
    /*
     * The administrator's login name of a server. Can only be specified when the server is being created (and is
     * required for creation).
     */
    private String administratorLogin;

    /*
     * The administrator login password (required for server creation).
     */
    private String administratorLoginPassword;

    /*
     * PostgreSQL Server version.
     */
    private ServerVersion version;

    /*
     * The minor version of the server.
     */
    private String minorVersion;

    /*
     * A state of a server that is visible to user.
     */
    private ServerState state;

    /*
     * The fully qualified domain name of a server.
     */
    private String fullyQualifiedDomainName;

    /*
     * Storage properties of a server.
     */
    private Storage storage;

    /*
     * AuthConfig properties of a server.
     */
    private AuthConfig authConfig;

    /*
     * Data encryption properties of a server.
     */
    private DataEncryption dataEncryption;

    /*
     * Backup properties of a server.
     */
    private Backup backup;

    /*
     * Network properties of a server. This Network property is required to be passed only in case you want the server
     * to be Private access server.
     */
    private Network network;

    /*
     * High availability properties of a server.
     */
    private HighAvailability highAvailability;

    /*
     * Maintenance window properties of a server.
     */
    private MaintenanceWindow maintenanceWindow;

    /*
     * The source server resource ID to restore from. It's required when 'createMode' is 'PointInTimeRestore' or
     * 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned only for Replica server
     */
    private String sourceServerResourceId;

    /*
     * Restore point creation time (ISO8601 format), specifying the time to restore from. It's required when
     * 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'.
     */
    private OffsetDateTime pointInTimeUtc;

    /*
     * availability zone information of the server.
     */
    private String availabilityZone;

    /*
     * Replication role of the server
     */
    private ReplicationRole replicationRole;

    /*
     * Replicas allowed for a server.
     */
    private Integer replicaCapacity;

    /*
     * Replica properties of a server. These Replica properties are required to be passed only in case you want to
     * Promote a server.
     */
    private Replica replica;

    /*
     * The mode to create a new PostgreSQL server.
     */
    private CreateMode createMode;

    /*
     * List of private endpoint connections associated with the specified resource.
     */
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /**
     * Creates an instance of ServerProperties class.
     */
    public ServerProperties() {
    }

    /**
     * Get the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is being created (and is required for creation).
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is being created (and is required for creation).
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword property: The administrator login password (required for server creation).
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the version property: PostgreSQL Server version.
     * 
     * @return the version value.
     */
    public ServerVersion version() {
        return this.version;
    }

    /**
     * Set the version property: PostgreSQL Server version.
     * 
     * @param version the version value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    /**
     * Get the minorVersion property: The minor version of the server.
     * 
     * @return the minorVersion value.
     */
    public String minorVersion() {
        return this.minorVersion;
    }

    /**
     * Get the state property: A state of a server that is visible to user.
     * 
     * @return the state value.
     */
    public ServerState state() {
        return this.state;
    }

    /**
     * Get the fullyQualifiedDomainName property: The fully qualified domain name of a server.
     * 
     * @return the fullyQualifiedDomainName value.
     */
    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    /**
     * Get the storage property: Storage properties of a server.
     * 
     * @return the storage value.
     */
    public Storage storage() {
        return this.storage;
    }

    /**
     * Set the storage property: Storage properties of a server.
     * 
     * @param storage the storage value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    /**
     * Get the authConfig property: AuthConfig properties of a server.
     * 
     * @return the authConfig value.
     */
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    /**
     * Set the authConfig property: AuthConfig properties of a server.
     * 
     * @param authConfig the authConfig value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    /**
     * Get the dataEncryption property: Data encryption properties of a server.
     * 
     * @return the dataEncryption value.
     */
    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    /**
     * Set the dataEncryption property: Data encryption properties of a server.
     * 
     * @param dataEncryption the dataEncryption value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    /**
     * Get the backup property: Backup properties of a server.
     * 
     * @return the backup value.
     */
    public Backup backup() {
        return this.backup;
    }

    /**
     * Set the backup property: Backup properties of a server.
     * 
     * @param backup the backup value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    /**
     * Get the network property: Network properties of a server. This Network property is required to be passed only in
     * case you want the server to be Private access server.
     * 
     * @return the network value.
     */
    public Network network() {
        return this.network;
    }

    /**
     * Set the network property: Network properties of a server. This Network property is required to be passed only in
     * case you want the server to be Private access server.
     * 
     * @param network the network value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withNetwork(Network network) {
        this.network = network;
        return this;
    }

    /**
     * Get the highAvailability property: High availability properties of a server.
     * 
     * @return the highAvailability value.
     */
    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    /**
     * Set the highAvailability property: High availability properties of a server.
     * 
     * @param highAvailability the highAvailability value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    /**
     * Get the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @return the maintenanceWindow value.
     */
    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    /**
     * Set the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @param maintenanceWindow the maintenanceWindow value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    /**
     * Get the sourceServerResourceId property: The source server resource ID to restore from. It's required when
     * 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned
     * only for Replica server.
     * 
     * @return the sourceServerResourceId value.
     */
    public String sourceServerResourceId() {
        return this.sourceServerResourceId;
    }

    /**
     * Set the sourceServerResourceId property: The source server resource ID to restore from. It's required when
     * 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'Replica' or 'ReviveDropped'. This property is returned
     * only for Replica server.
     * 
     * @param sourceServerResourceId the sourceServerResourceId value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withSourceServerResourceId(String sourceServerResourceId) {
        this.sourceServerResourceId = sourceServerResourceId;
        return this;
    }

    /**
     * Get the pointInTimeUtc property: Restore point creation time (ISO8601 format), specifying the time to restore
     * from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'.
     * 
     * @return the pointInTimeUtc value.
     */
    public OffsetDateTime pointInTimeUtc() {
        return this.pointInTimeUtc;
    }

    /**
     * Set the pointInTimeUtc property: Restore point creation time (ISO8601 format), specifying the time to restore
     * from. It's required when 'createMode' is 'PointInTimeRestore' or 'GeoRestore' or 'ReviveDropped'.
     * 
     * @param pointInTimeUtc the pointInTimeUtc value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withPointInTimeUtc(OffsetDateTime pointInTimeUtc) {
        this.pointInTimeUtc = pointInTimeUtc;
        return this;
    }

    /**
     * Get the availabilityZone property: availability zone information of the server.
     * 
     * @return the availabilityZone value.
     */
    public String availabilityZone() {
        return this.availabilityZone;
    }

    /**
     * Set the availabilityZone property: availability zone information of the server.
     * 
     * @param availabilityZone the availabilityZone value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    /**
     * Get the replicationRole property: Replication role of the server.
     * 
     * @return the replicationRole value.
     */
    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Set the replicationRole property: Replication role of the server.
     * 
     * @param replicationRole the replicationRole value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    /**
     * Get the replicaCapacity property: Replicas allowed for a server.
     * 
     * @return the replicaCapacity value.
     */
    public Integer replicaCapacity() {
        return this.replicaCapacity;
    }

    /**
     * Get the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @return the replica value.
     */
    public Replica replica() {
        return this.replica;
    }

    /**
     * Set the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @param replica the replica value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withReplica(Replica replica) {
        this.replica = replica;
        return this;
    }

    /**
     * Get the createMode property: The mode to create a new PostgreSQL server.
     * 
     * @return the createMode value.
     */
    public CreateMode createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode property: The mode to create a new PostgreSQL server.
     * 
     * @param createMode the createMode value to set.
     * @return the ServerProperties object itself.
     */
    public ServerProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of private endpoint connections associated with the specified
     * resource.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storage() != null) {
            storage().validate();
        }
        if (authConfig() != null) {
            authConfig().validate();
        }
        if (dataEncryption() != null) {
            dataEncryption().validate();
        }
        if (backup() != null) {
            backup().validate();
        }
        if (network() != null) {
            network().validate();
        }
        if (highAvailability() != null) {
            highAvailability().validate();
        }
        if (maintenanceWindow() != null) {
            maintenanceWindow().validate();
        }
        if (replica() != null) {
            replica().validate();
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeJsonField("storage", this.storage);
        jsonWriter.writeJsonField("authConfig", this.authConfig);
        jsonWriter.writeJsonField("dataEncryption", this.dataEncryption);
        jsonWriter.writeJsonField("backup", this.backup);
        jsonWriter.writeJsonField("network", this.network);
        jsonWriter.writeJsonField("highAvailability", this.highAvailability);
        jsonWriter.writeJsonField("maintenanceWindow", this.maintenanceWindow);
        jsonWriter.writeStringField("sourceServerResourceId", this.sourceServerResourceId);
        jsonWriter.writeStringField("pointInTimeUTC",
            this.pointInTimeUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.pointInTimeUtc));
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeStringField("replicationRole",
            this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("replica", this.replica);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerProperties.
     */
    public static ServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerProperties deserializedServerProperties = new ServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerProperties.administratorLogin = reader.getString();
                } else if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerProperties.administratorLoginPassword = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedServerProperties.version = ServerVersion.fromString(reader.getString());
                } else if ("minorVersion".equals(fieldName)) {
                    deserializedServerProperties.minorVersion = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedServerProperties.state = ServerState.fromString(reader.getString());
                } else if ("fullyQualifiedDomainName".equals(fieldName)) {
                    deserializedServerProperties.fullyQualifiedDomainName = reader.getString();
                } else if ("storage".equals(fieldName)) {
                    deserializedServerProperties.storage = Storage.fromJson(reader);
                } else if ("authConfig".equals(fieldName)) {
                    deserializedServerProperties.authConfig = AuthConfig.fromJson(reader);
                } else if ("dataEncryption".equals(fieldName)) {
                    deserializedServerProperties.dataEncryption = DataEncryption.fromJson(reader);
                } else if ("backup".equals(fieldName)) {
                    deserializedServerProperties.backup = Backup.fromJson(reader);
                } else if ("network".equals(fieldName)) {
                    deserializedServerProperties.network = Network.fromJson(reader);
                } else if ("highAvailability".equals(fieldName)) {
                    deserializedServerProperties.highAvailability = HighAvailability.fromJson(reader);
                } else if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerProperties.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                } else if ("sourceServerResourceId".equals(fieldName)) {
                    deserializedServerProperties.sourceServerResourceId = reader.getString();
                } else if ("pointInTimeUTC".equals(fieldName)) {
                    deserializedServerProperties.pointInTimeUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("availabilityZone".equals(fieldName)) {
                    deserializedServerProperties.availabilityZone = reader.getString();
                } else if ("replicationRole".equals(fieldName)) {
                    deserializedServerProperties.replicationRole = ReplicationRole.fromString(reader.getString());
                } else if ("replicaCapacity".equals(fieldName)) {
                    deserializedServerProperties.replicaCapacity = reader.getNullable(JsonReader::getInt);
                } else if ("replica".equals(fieldName)) {
                    deserializedServerProperties.replica = Replica.fromJson(reader);
                } else if ("createMode".equals(fieldName)) {
                    deserializedServerProperties.createMode = CreateMode.fromString(reader.getString());
                } else if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections
                        = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedServerProperties.privateEndpointConnections = privateEndpointConnections;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerProperties;
        });
    }
}
