// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.AuthConfig;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Backup;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CreateModeForUpdate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryption;
import com.azure.resourcemanager.postgresqlflexibleserver.models.HighAvailability;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MaintenanceWindow;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Network;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replica;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ReplicationRole;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerVersion;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Storage;
import java.io.IOException;

/**
 * The ServerPropertiesForUpdate model.
 */
@Fluent
public final class ServerPropertiesForUpdate implements JsonSerializable<ServerPropertiesForUpdate> {
    /*
     * The administrator's login name of a server. Can only be specified when the server is trying to switch to password
     * authentication and does not have default administrator login.
     */
    private String administratorLogin;

    /*
     * The password of the administrator login.
     */
    private String administratorLoginPassword;

    /*
     * PostgreSQL Server version. Version 16 is currently not supported for MVU.
     */
    private ServerVersion version;

    /*
     * Storage properties of a server.
     */
    private Storage storage;

    /*
     * Backup properties of a server.
     */
    private Backup backup;

    /*
     * High availability properties of a server.
     */
    private HighAvailability highAvailability;

    /*
     * Maintenance window properties of a server.
     */
    private MaintenanceWindow maintenanceWindow;

    /*
     * AuthConfig properties of a server.
     */
    private AuthConfig authConfig;

    /*
     * Data encryption properties of a server.
     */
    private DataEncryption dataEncryption;

    /*
     * The mode to update a new PostgreSQL server.
     */
    private CreateModeForUpdate createMode;

    /*
     * Replication role of the server
     */
    private ReplicationRole replicationRole;

    /*
     * Replica properties of a server. These Replica properties are required to be passed only in case you want to
     * Promote a server.
     */
    private Replica replica;

    /*
     * Network properties of a server. These are required to be passed only in case if server is a private access
     * server.
     */
    private Network network;

    /**
     * Creates an instance of ServerPropertiesForUpdate class.
     */
    public ServerPropertiesForUpdate() {
    }

    /**
     * Get the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is trying to switch to password authentication and does not have default administrator login.
     * 
     * @return the administratorLogin value.
     */
    public String administratorLogin() {
        return this.administratorLogin;
    }

    /**
     * Set the administratorLogin property: The administrator's login name of a server. Can only be specified when the
     * server is trying to switch to password authentication and does not have default administrator login.
     * 
     * @param administratorLogin the administratorLogin value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    /**
     * Get the administratorLoginPassword property: The password of the administrator login.
     * 
     * @return the administratorLoginPassword value.
     */
    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    /**
     * Set the administratorLoginPassword property: The password of the administrator login.
     * 
     * @param administratorLoginPassword the administratorLoginPassword value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    /**
     * Get the version property: PostgreSQL Server version. Version 16 is currently not supported for MVU.
     * 
     * @return the version value.
     */
    public ServerVersion version() {
        return this.version;
    }

    /**
     * Set the version property: PostgreSQL Server version. Version 16 is currently not supported for MVU.
     * 
     * @param version the version value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    /**
     * Get the storage property: Storage properties of a server.
     * 
     * @return the storage value.
     */
    public Storage storage() {
        return this.storage;
    }

    /**
     * Set the storage property: Storage properties of a server.
     * 
     * @param storage the storage value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withStorage(Storage storage) {
        this.storage = storage;
        return this;
    }

    /**
     * Get the backup property: Backup properties of a server.
     * 
     * @return the backup value.
     */
    public Backup backup() {
        return this.backup;
    }

    /**
     * Set the backup property: Backup properties of a server.
     * 
     * @param backup the backup value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withBackup(Backup backup) {
        this.backup = backup;
        return this;
    }

    /**
     * Get the highAvailability property: High availability properties of a server.
     * 
     * @return the highAvailability value.
     */
    public HighAvailability highAvailability() {
        return this.highAvailability;
    }

    /**
     * Set the highAvailability property: High availability properties of a server.
     * 
     * @param highAvailability the highAvailability value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withHighAvailability(HighAvailability highAvailability) {
        this.highAvailability = highAvailability;
        return this;
    }

    /**
     * Get the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @return the maintenanceWindow value.
     */
    public MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    /**
     * Set the maintenanceWindow property: Maintenance window properties of a server.
     * 
     * @param maintenanceWindow the maintenanceWindow value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withMaintenanceWindow(MaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    /**
     * Get the authConfig property: AuthConfig properties of a server.
     * 
     * @return the authConfig value.
     */
    public AuthConfig authConfig() {
        return this.authConfig;
    }

    /**
     * Set the authConfig property: AuthConfig properties of a server.
     * 
     * @param authConfig the authConfig value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    /**
     * Get the dataEncryption property: Data encryption properties of a server.
     * 
     * @return the dataEncryption value.
     */
    public DataEncryption dataEncryption() {
        return this.dataEncryption;
    }

    /**
     * Set the dataEncryption property: Data encryption properties of a server.
     * 
     * @param dataEncryption the dataEncryption value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withDataEncryption(DataEncryption dataEncryption) {
        this.dataEncryption = dataEncryption;
        return this;
    }

    /**
     * Get the createMode property: The mode to update a new PostgreSQL server.
     * 
     * @return the createMode value.
     */
    public CreateModeForUpdate createMode() {
        return this.createMode;
    }

    /**
     * Set the createMode property: The mode to update a new PostgreSQL server.
     * 
     * @param createMode the createMode value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withCreateMode(CreateModeForUpdate createMode) {
        this.createMode = createMode;
        return this;
    }

    /**
     * Get the replicationRole property: Replication role of the server.
     * 
     * @return the replicationRole value.
     */
    public ReplicationRole replicationRole() {
        return this.replicationRole;
    }

    /**
     * Set the replicationRole property: Replication role of the server.
     * 
     * @param replicationRole the replicationRole value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withReplicationRole(ReplicationRole replicationRole) {
        this.replicationRole = replicationRole;
        return this;
    }

    /**
     * Get the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @return the replica value.
     */
    public Replica replica() {
        return this.replica;
    }

    /**
     * Set the replica property: Replica properties of a server. These Replica properties are required to be passed only
     * in case you want to Promote a server.
     * 
     * @param replica the replica value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withReplica(Replica replica) {
        this.replica = replica;
        return this;
    }

    /**
     * Get the network property: Network properties of a server. These are required to be passed only in case if server
     * is a private access server.
     * 
     * @return the network value.
     */
    public Network network() {
        return this.network;
    }

    /**
     * Set the network property: Network properties of a server. These are required to be passed only in case if server
     * is a private access server.
     * 
     * @param network the network value to set.
     * @return the ServerPropertiesForUpdate object itself.
     */
    public ServerPropertiesForUpdate withNetwork(Network network) {
        this.network = network;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storage() != null) {
            storage().validate();
        }
        if (backup() != null) {
            backup().validate();
        }
        if (highAvailability() != null) {
            highAvailability().validate();
        }
        if (maintenanceWindow() != null) {
            maintenanceWindow().validate();
        }
        if (authConfig() != null) {
            authConfig().validate();
        }
        if (dataEncryption() != null) {
            dataEncryption().validate();
        }
        if (replica() != null) {
            replica().validate();
        }
        if (network() != null) {
            network().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeJsonField("storage", this.storage);
        jsonWriter.writeJsonField("backup", this.backup);
        jsonWriter.writeJsonField("highAvailability", this.highAvailability);
        jsonWriter.writeJsonField("maintenanceWindow", this.maintenanceWindow);
        jsonWriter.writeJsonField("authConfig", this.authConfig);
        jsonWriter.writeJsonField("dataEncryption", this.dataEncryption);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("replicationRole",
            this.replicationRole == null ? null : this.replicationRole.toString());
        jsonWriter.writeJsonField("replica", this.replica);
        jsonWriter.writeJsonField("network", this.network);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerPropertiesForUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerPropertiesForUpdate if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ServerPropertiesForUpdate.
     */
    public static ServerPropertiesForUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerPropertiesForUpdate deserializedServerPropertiesForUpdate = new ServerPropertiesForUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.administratorLogin = reader.getString();
                } else if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.administratorLoginPassword = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.version = ServerVersion.fromString(reader.getString());
                } else if ("storage".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.storage = Storage.fromJson(reader);
                } else if ("backup".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.backup = Backup.fromJson(reader);
                } else if ("highAvailability".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.highAvailability = HighAvailability.fromJson(reader);
                } else if ("maintenanceWindow".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.maintenanceWindow = MaintenanceWindow.fromJson(reader);
                } else if ("authConfig".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.authConfig = AuthConfig.fromJson(reader);
                } else if ("dataEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.dataEncryption = DataEncryption.fromJson(reader);
                } else if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.createMode
                        = CreateModeForUpdate.fromString(reader.getString());
                } else if ("replicationRole".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.replicationRole
                        = ReplicationRole.fromString(reader.getString());
                } else if ("replica".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.replica = Replica.fromJson(reader);
                } else if ("network".equals(fieldName)) {
                    deserializedServerPropertiesForUpdate.network = Network.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerPropertiesForUpdate;
        });
    }
}
