// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionState;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Server's Advanced Threat Protection settings.
 */
@Fluent
public final class ServerThreatProtectionSettingsModelInner extends ProxyResource {
    /*
     * Advanced Threat Protection properties.
     */
    private ServerThreatProtectionProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ServerThreatProtectionSettingsModelInner class.
     */
    public ServerThreatProtectionSettingsModelInner() {
    }

    /**
     * Get the innerProperties property: Advanced Threat Protection properties.
     * 
     * @return the innerProperties value.
     */
    private ServerThreatProtectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the state property: Specifies the state of the Threat Protection, whether it is enabled or disabled or a
     * state has not been applied yet on the specific server.
     * 
     * @return the state value.
     */
    public ThreatProtectionState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    /**
     * Set the state property: Specifies the state of the Threat Protection, whether it is enabled or disabled or a
     * state has not been applied yet on the specific server.
     * 
     * @param state the state value to set.
     * @return the ServerThreatProtectionSettingsModelInner object itself.
     */
    public ServerThreatProtectionSettingsModelInner withState(ThreatProtectionState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerThreatProtectionProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    /**
     * Get the creationTime property: Specifies the UTC creation time of the policy.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServerThreatProtectionSettingsModelInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServerThreatProtectionSettingsModelInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServerThreatProtectionSettingsModelInner.
     */
    public static ServerThreatProtectionSettingsModelInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerThreatProtectionSettingsModelInner deserializedServerThreatProtectionSettingsModelInner
                = new ServerThreatProtectionSettingsModelInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedServerThreatProtectionSettingsModelInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedServerThreatProtectionSettingsModelInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedServerThreatProtectionSettingsModelInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedServerThreatProtectionSettingsModelInner.innerProperties
                        = ServerThreatProtectionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedServerThreatProtectionSettingsModelInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedServerThreatProtectionSettingsModelInner;
        });
    }
}
