// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointType;
import java.io.IOException;
import java.util.List;

/**
 * Represents a virtual endpoint for a server.
 */
@Fluent
public final class VirtualEndpointResourceInner extends VirtualEndpointResourceForPatch {
    /*
     * Fully qualified resource ID for the resource. E.g.
     * "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
     */
    private String id;

    /*
     * The name of the resource
     */
    private String name;

    /*
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    private String type;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * Properties of the virtual endpoint resource.
     */
    private VirtualEndpointResourceProperties innerProperties;

    /**
     * Creates an instance of VirtualEndpointResourceInner class.
     */
    public VirtualEndpointResourceInner() {
    }

    /**
     * Get the id property: Fully qualified resource ID for the resource. E.g.
     * "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     * "Microsoft.Storage/storageAccounts".
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the innerProperties property: Properties of the virtual endpoint resource.
     * 
     * @return the innerProperties value.
     */
    private VirtualEndpointResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the endpointType property: The endpoint type for the virtual endpoint.
     * 
     * @return the endpointType value.
     */
    public VirtualEndpointType endpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointType();
    }

    /**
     * Set the endpointType property: The endpoint type for the virtual endpoint.
     * 
     * @param endpointType the endpointType value to set.
     * @return the VirtualEndpointResourceInner object itself.
     */
    public VirtualEndpointResourceInner withEndpointType(VirtualEndpointType endpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withEndpointType(endpointType);
        return this;
    }

    /**
     * Get the members property: List of members for a virtual endpoint.
     * 
     * @return the members value.
     */
    public List<String> members() {
        return this.innerProperties() == null ? null : this.innerProperties().members();
    }

    /**
     * Set the members property: List of members for a virtual endpoint.
     * 
     * @param members the members value to set.
     * @return the VirtualEndpointResourceInner object itself.
     */
    public VirtualEndpointResourceInner withMembers(List<String> members) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withMembers(members);
        return this;
    }

    /**
     * Get the virtualEndpoints property: List of virtual endpoints for a server.
     * 
     * @return the virtualEndpoints value.
     */
    public List<String> virtualEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualEndpoints();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", innerProperties());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualEndpointResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualEndpointResourceInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualEndpointResourceInner.
     */
    public static VirtualEndpointResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualEndpointResourceInner deserializedVirtualEndpointResourceInner = new VirtualEndpointResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.innerProperties
                        = VirtualEndpointResourceProperties.fromJson(reader);
                } else if ("id".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualEndpointResourceInner;
        });
    }
}
