// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DelegatedSubnetUsage;
import java.io.IOException;
import java.util.List;

/**
 * Virtual network subnet usage data.
 */
@Immutable
public final class VirtualNetworkSubnetUsageResultInner
    implements JsonSerializable<VirtualNetworkSubnetUsageResultInner> {
    /*
     * The delegatedSubnetsUsage property.
     */
    private List<DelegatedSubnetUsage> delegatedSubnetsUsage;

    /*
     * location of the delegated subnet usage
     */
    private String location;

    /*
     * subscriptionId of the delegated subnet usage
     */
    private String subscriptionId;

    /**
     * Creates an instance of VirtualNetworkSubnetUsageResultInner class.
     */
    public VirtualNetworkSubnetUsageResultInner() {
    }

    /**
     * Get the delegatedSubnetsUsage property: The delegatedSubnetsUsage property.
     * 
     * @return the delegatedSubnetsUsage value.
     */
    public List<DelegatedSubnetUsage> delegatedSubnetsUsage() {
        return this.delegatedSubnetsUsage;
    }

    /**
     * Get the location property: location of the delegated subnet usage.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the subscriptionId property: subscriptionId of the delegated subnet usage.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (delegatedSubnetsUsage() != null) {
            delegatedSubnetsUsage().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkSubnetUsageResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkSubnetUsageResultInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkSubnetUsageResultInner.
     */
    public static VirtualNetworkSubnetUsageResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkSubnetUsageResultInner deserializedVirtualNetworkSubnetUsageResultInner
                = new VirtualNetworkSubnetUsageResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("delegatedSubnetsUsage".equals(fieldName)) {
                    List<DelegatedSubnetUsage> delegatedSubnetsUsage
                        = reader.readArray(reader1 -> DelegatedSubnetUsage.fromJson(reader1));
                    deserializedVirtualNetworkSubnetUsageResultInner.delegatedSubnetsUsage = delegatedSubnetsUsage;
                } else if ("location".equals(fieldName)) {
                    deserializedVirtualNetworkSubnetUsageResultInner.location = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedVirtualNetworkSubnetUsageResultInner.subscriptionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkSubnetUsageResultInner;
        });
    }
}
