// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ActiveDirectoryAdministratorInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ActiveDirectoryAdministrator;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ActiveDirectoryAdministratorAdd;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrincipalType;

public final class ActiveDirectoryAdministratorImpl
    implements ActiveDirectoryAdministrator, ActiveDirectoryAdministrator.Definition {
    private ActiveDirectoryAdministratorInner innerObject;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    ActiveDirectoryAdministratorImpl(ActiveDirectoryAdministratorInner innerObject,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public PrincipalType principalType() {
        return this.innerModel().principalType();
    }

    public String principalName() {
        return this.innerModel().principalName();
    }

    public String objectId() {
        return this.innerModel().objectId();
    }

    public String tenantId() {
        return this.innerModel().tenantId();
    }

    public ActiveDirectoryAdministratorInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serverName;

    private String objectId;

    private ActiveDirectoryAdministratorAdd createParameters;

    public ActiveDirectoryAdministratorImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    public ActiveDirectoryAdministrator create() {
        this.innerObject = serviceManager.serviceClient()
            .getAdministrators()
            .create(resourceGroupName, serverName, objectId, createParameters, Context.NONE);
        return this;
    }

    public ActiveDirectoryAdministrator create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAdministrators()
            .create(resourceGroupName, serverName, objectId, createParameters, context);
        return this;
    }

    ActiveDirectoryAdministratorImpl(String name,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerObject = new ActiveDirectoryAdministratorInner();
        this.serviceManager = serviceManager;
        this.objectId = name;
        this.createParameters = new ActiveDirectoryAdministratorAdd();
    }

    public ActiveDirectoryAdministrator refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getAdministrators()
            .getWithResponse(resourceGroupName, serverName, objectId, Context.NONE)
            .getValue();
        return this;
    }

    public ActiveDirectoryAdministrator refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getAdministrators()
            .getWithResponse(resourceGroupName, serverName, objectId, context)
            .getValue();
        return this;
    }

    public ActiveDirectoryAdministratorImpl withPrincipalType(PrincipalType principalType) {
        this.createParameters.withPrincipalType(principalType);
        return this;
    }

    public ActiveDirectoryAdministratorImpl withPrincipalName(String principalName) {
        this.createParameters.withPrincipalName(principalName);
        return this;
    }

    public ActiveDirectoryAdministratorImpl withTenantId(String tenantId) {
        this.createParameters.withTenantId(tenantId);
        return this;
    }
}
