// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ConfigurationInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Configuration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigurationDataType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigurationForUpdate;

public final class ConfigurationImpl implements Configuration, Configuration.Definition, Configuration.Update {
    private ConfigurationInner innerObject;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public String value() {
        return this.innerModel().value();
    }

    public String description() {
        return this.innerModel().description();
    }

    public String defaultValue() {
        return this.innerModel().defaultValue();
    }

    public ConfigurationDataType dataType() {
        return this.innerModel().dataType();
    }

    public String allowedValues() {
        return this.innerModel().allowedValues();
    }

    public String source() {
        return this.innerModel().source();
    }

    public Boolean isDynamicConfig() {
        return this.innerModel().isDynamicConfig();
    }

    public Boolean isReadOnly() {
        return this.innerModel().isReadOnly();
    }

    public Boolean isConfigPendingRestart() {
        return this.innerModel().isConfigPendingRestart();
    }

    public String unit() {
        return this.innerModel().unit();
    }

    public String documentationLink() {
        return this.innerModel().documentationLink();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ConfigurationInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serverName;

    private String configurationName;

    private ConfigurationForUpdate updateParameters;

    public ConfigurationImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    public Configuration create() {
        this.innerObject = serviceManager.serviceClient()
            .getConfigurations()
            .put(resourceGroupName, serverName, configurationName, this.innerModel(), Context.NONE);
        return this;
    }

    public Configuration create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConfigurations()
            .put(resourceGroupName, serverName, configurationName, this.innerModel(), context);
        return this;
    }

    ConfigurationImpl(String name,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerObject = new ConfigurationInner();
        this.serviceManager = serviceManager;
        this.configurationName = name;
    }

    public ConfigurationImpl update() {
        this.updateParameters = new ConfigurationForUpdate();
        return this;
    }

    public Configuration apply() {
        this.innerObject = serviceManager.serviceClient()
            .getConfigurations()
            .update(resourceGroupName, serverName, configurationName, updateParameters, Context.NONE);
        return this;
    }

    public Configuration apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConfigurations()
            .update(resourceGroupName, serverName, configurationName, updateParameters, context);
        return this;
    }

    ConfigurationImpl(ConfigurationInner innerObject,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.configurationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurations");
    }

    public Configuration refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getConfigurations()
            .getWithResponse(resourceGroupName, serverName, configurationName, Context.NONE)
            .getValue();
        return this;
    }

    public Configuration refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getConfigurations()
            .getWithResponse(resourceGroupName, serverName, configurationName, context)
            .getValue();
        return this;
    }

    public ConfigurationImpl withValue(String value) {
        if (isInCreateMode()) {
            this.innerModel().withValue(value);
            return this;
        } else {
            this.updateParameters.withValue(value);
            return this;
        }
    }

    public ConfigurationImpl withSource(String source) {
        if (isInCreateMode()) {
            this.innerModel().withSource(source);
            return this;
        } else {
            this.updateParameters.withSource(source);
            return this;
        }
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}
