// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationListFilter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResourceListResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in MigrationsClient.
 */
public final class MigrationsClientImpl implements MigrationsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final MigrationsService service;

    /**
     * The service client containing this operation class.
     */
    private final PostgreSqlManagementClientImpl client;

    /**
     * Initializes an instance of MigrationsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    MigrationsClientImpl(PostgreSqlManagementClientImpl client) {
        this.service
            = RestProxy.create(MigrationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PostgreSqlManagementClientMigrations to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PostgreSqlManagement")
    public interface MigrationsService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MigrationResourceInner>> create(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("targetDbServerName") String targetDbServerName,
            @PathParam("migrationName") String migrationName,
            @BodyParam("application/json") MigrationResourceInner parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MigrationResourceInner>> get(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("targetDbServerName") String targetDbServerName,
            @PathParam("migrationName") String migrationName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MigrationResourceInner>> update(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("targetDbServerName") String targetDbServerName,
            @PathParam("migrationName") String migrationName,
            @BodyParam("application/json") MigrationResourceForPatch parameters, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("targetDbServerName") String targetDbServerName,
            @PathParam("migrationName") String migrationName, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MigrationResourceListResult>> listByTargetServer(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("targetDbServerName") String targetDbServerName,
            @QueryParam("migrationListFilter") MigrationListFilter migrationListFilter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MigrationResourceListResult>> listByTargetServerNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MigrationResourceInner>> createWithResponseAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.create(this.client.getEndpoint(), this.client.getApiVersion(),
                subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MigrationResourceInner>> createWithResponseAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.create(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName,
            targetDbServerName, migrationName, parameters, accept, context);
    }

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MigrationResourceInner> createAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceInner parameters) {
        return createWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MigrationResourceInner> createWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceInner parameters, Context context) {
        return createWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters,
            context).block();
    }

    /**
     * Creates a new migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for creating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MigrationResourceInner create(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, MigrationResourceInner parameters) {
        return createWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters,
            Context.NONE).getValue();
    }

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MigrationResourceInner>> getWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId,
                resourceGroupName, targetDbServerName, migrationName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MigrationResourceInner>> getWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName,
            targetDbServerName, migrationName, accept, context);
    }

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MigrationResourceInner> getAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName) {
        return getWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MigrationResourceInner> getWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, Context context) {
        return getWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context)
            .block();
    }

    /**
     * Gets details of a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return details of a migration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MigrationResourceInner get(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName) {
        return getWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, Context.NONE)
            .getValue();
    }

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MigrationResourceInner>> updateWithResponseAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, String migrationName,
        MigrationResourceForPatch parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getApiVersion(),
                subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MigrationResourceInner>> updateWithResponseAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceForPatch parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName,
            targetDbServerName, migrationName, parameters, accept, context);
    }

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MigrationResourceInner> updateAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceForPatch parameters) {
        return updateWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MigrationResourceInner> updateWithResponse(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, MigrationResourceForPatch parameters, Context context) {
        return updateWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters,
            context).block();
    }

    /**
     * Updates an existing migration. The request body can contain one to many of the mutable properties present in the
     * migration definition. Certain property updates initiate migration state transitions.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param parameters The required parameters for updating a migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MigrationResourceInner update(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, MigrationResourceForPatch parameters) {
        return updateWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters,
            Context.NONE).getValue();
    }

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getApiVersion(),
                subscriptionId, resourceGroupName, targetDbServerName, migrationName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, String migrationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName,
            targetDbServerName, migrationName, accept, context);
    }

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName) {
        return deleteWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName, Context context) {
        return deleteWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context)
            .block();
    }

    /**
     * Deletes a migration.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationName The name of the migration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String subscriptionId, String resourceGroupName, String targetDbServerName,
        String migrationName) {
        deleteWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, Context.NONE);
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerSinglePageAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByTargetServer(this.client.getEndpoint(), this.client.getApiVersion(),
                subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter, accept, context))
            .<PagedResponse<MigrationResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerSinglePageAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByTargetServer(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId,
                resourceGroupName, targetDbServerName, migrationListFilter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationListFilter migrationListFilter) {
        return new PagedFlux<>(() -> listByTargetServerSinglePageAsync(subscriptionId, resourceGroupName,
            targetDbServerName, migrationListFilter), nextLink -> listByTargetServerNextSinglePageAsync(nextLink));
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName) {
        final MigrationListFilter migrationListFilter = null;
        return new PagedFlux<>(() -> listByTargetServerSinglePageAsync(subscriptionId, resourceGroupName,
            targetDbServerName, migrationListFilter), nextLink -> listByTargetServerNextSinglePageAsync(nextLink));
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        return new PagedFlux<>(() -> listByTargetServerSinglePageAsync(subscriptionId, resourceGroupName,
            targetDbServerName, migrationListFilter, context),
            nextLink -> listByTargetServerNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MigrationResourceInner> listByTargetServer(String subscriptionId, String resourceGroupName,
        String targetDbServerName) {
        final MigrationListFilter migrationListFilter = null;
        return new PagedIterable<>(
            listByTargetServerAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter));
    }

    /**
     * List all the migrations on a given target server.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param migrationListFilter Migration list filter. Retrieves either active migrations or all migrations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MigrationResourceInner> listByTargetServer(String subscriptionId, String resourceGroupName,
        String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        return new PagedIterable<>(listByTargetServerAsync(subscriptionId, resourceGroupName, targetDbServerName,
            migrationListFilter, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByTargetServerNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<MigrationResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of migration resources along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByTargetServerNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
