// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.AdministratorsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.BackupsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CheckNameAvailabilityWithLocationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ConfigurationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.DatabasesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.FirewallRulesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.FlexibleServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.GetPrivateDnsZoneSuffixesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LocationBasedCapabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LogFilesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.LtrBackupOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.OperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PostgreSqlManagementClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ReplicasClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerCapabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualEndpointsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualNetworkSubnetUsagesClient;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the PostgreSqlManagementClientImpl type.
 */
@ServiceClient(builder = PostgreSqlManagementClientBuilder.class)
public final class PostgreSqlManagementClientImpl implements PostgreSqlManagementClient {
    /**
     * The ID of the target subscription. The value must be an UUID.
     */
    private final String subscriptionId;

    /**
     * Gets The ID of the target subscription. The value must be an UUID.
     * 
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /**
     * server parameter.
     */
    private final String endpoint;

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Api Version.
     */
    private final String apiVersion;

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * The default poll interval for long-running operation.
     */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /**
     * The AdministratorsClient object to access its operations.
     */
    private final AdministratorsClient administrators;

    /**
     * Gets the AdministratorsClient object to access its operations.
     * 
     * @return the AdministratorsClient object.
     */
    public AdministratorsClient getAdministrators() {
        return this.administrators;
    }

    /**
     * The BackupsClient object to access its operations.
     */
    private final BackupsClient backups;

    /**
     * Gets the BackupsClient object to access its operations.
     * 
     * @return the BackupsClient object.
     */
    public BackupsClient getBackups() {
        return this.backups;
    }

    /**
     * The LocationBasedCapabilitiesClient object to access its operations.
     */
    private final LocationBasedCapabilitiesClient locationBasedCapabilities;

    /**
     * Gets the LocationBasedCapabilitiesClient object to access its operations.
     * 
     * @return the LocationBasedCapabilitiesClient object.
     */
    public LocationBasedCapabilitiesClient getLocationBasedCapabilities() {
        return this.locationBasedCapabilities;
    }

    /**
     * The ServerCapabilitiesClient object to access its operations.
     */
    private final ServerCapabilitiesClient serverCapabilities;

    /**
     * Gets the ServerCapabilitiesClient object to access its operations.
     * 
     * @return the ServerCapabilitiesClient object.
     */
    public ServerCapabilitiesClient getServerCapabilities() {
        return this.serverCapabilities;
    }

    /**
     * The CheckNameAvailabilitiesClient object to access its operations.
     */
    private final CheckNameAvailabilitiesClient checkNameAvailabilities;

    /**
     * Gets the CheckNameAvailabilitiesClient object to access its operations.
     * 
     * @return the CheckNameAvailabilitiesClient object.
     */
    public CheckNameAvailabilitiesClient getCheckNameAvailabilities() {
        return this.checkNameAvailabilities;
    }

    /**
     * The CheckNameAvailabilityWithLocationsClient object to access its operations.
     */
    private final CheckNameAvailabilityWithLocationsClient checkNameAvailabilityWithLocations;

    /**
     * Gets the CheckNameAvailabilityWithLocationsClient object to access its operations.
     * 
     * @return the CheckNameAvailabilityWithLocationsClient object.
     */
    public CheckNameAvailabilityWithLocationsClient getCheckNameAvailabilityWithLocations() {
        return this.checkNameAvailabilityWithLocations;
    }

    /**
     * The ConfigurationsClient object to access its operations.
     */
    private final ConfigurationsClient configurations;

    /**
     * Gets the ConfigurationsClient object to access its operations.
     * 
     * @return the ConfigurationsClient object.
     */
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    /**
     * The DatabasesClient object to access its operations.
     */
    private final DatabasesClient databases;

    /**
     * Gets the DatabasesClient object to access its operations.
     * 
     * @return the DatabasesClient object.
     */
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    /**
     * The FirewallRulesClient object to access its operations.
     */
    private final FirewallRulesClient firewallRules;

    /**
     * Gets the FirewallRulesClient object to access its operations.
     * 
     * @return the FirewallRulesClient object.
     */
    public FirewallRulesClient getFirewallRules() {
        return this.firewallRules;
    }

    /**
     * The ServersClient object to access its operations.
     */
    private final ServersClient servers;

    /**
     * Gets the ServersClient object to access its operations.
     * 
     * @return the ServersClient object.
     */
    public ServersClient getServers() {
        return this.servers;
    }

    /**
     * The FlexibleServersClient object to access its operations.
     */
    private final FlexibleServersClient flexibleServers;

    /**
     * Gets the FlexibleServersClient object to access its operations.
     * 
     * @return the FlexibleServersClient object.
     */
    public FlexibleServersClient getFlexibleServers() {
        return this.flexibleServers;
    }

    /**
     * The LtrBackupOperationsClient object to access its operations.
     */
    private final LtrBackupOperationsClient ltrBackupOperations;

    /**
     * Gets the LtrBackupOperationsClient object to access its operations.
     * 
     * @return the LtrBackupOperationsClient object.
     */
    public LtrBackupOperationsClient getLtrBackupOperations() {
        return this.ltrBackupOperations;
    }

    /**
     * The MigrationsClient object to access its operations.
     */
    private final MigrationsClient migrations;

    /**
     * Gets the MigrationsClient object to access its operations.
     * 
     * @return the MigrationsClient object.
     */
    public MigrationsClient getMigrations() {
        return this.migrations;
    }

    /**
     * The ResourceProvidersClient object to access its operations.
     */
    private final ResourceProvidersClient resourceProviders;

    /**
     * Gets the ResourceProvidersClient object to access its operations.
     * 
     * @return the ResourceProvidersClient object.
     */
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    /**
     * The OperationsClient object to access its operations.
     */
    private final OperationsClient operations;

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    public OperationsClient getOperations() {
        return this.operations;
    }

    /**
     * The GetPrivateDnsZoneSuffixesClient object to access its operations.
     */
    private final GetPrivateDnsZoneSuffixesClient getPrivateDnsZoneSuffixes;

    /**
     * Gets the GetPrivateDnsZoneSuffixesClient object to access its operations.
     * 
     * @return the GetPrivateDnsZoneSuffixesClient object.
     */
    public GetPrivateDnsZoneSuffixesClient getGetPrivateDnsZoneSuffixes() {
        return this.getPrivateDnsZoneSuffixes;
    }

    /**
     * The PrivateEndpointConnectionsClient object to access its operations.
     */
    private final PrivateEndpointConnectionsClient privateEndpointConnections;

    /**
     * Gets the PrivateEndpointConnectionsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionsClient object.
     */
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * The PrivateEndpointConnectionOperationsClient object to access its operations.
     */
    private final PrivateEndpointConnectionOperationsClient privateEndpointConnectionOperations;

    /**
     * Gets the PrivateEndpointConnectionOperationsClient object to access its operations.
     * 
     * @return the PrivateEndpointConnectionOperationsClient object.
     */
    public PrivateEndpointConnectionOperationsClient getPrivateEndpointConnectionOperations() {
        return this.privateEndpointConnectionOperations;
    }

    /**
     * The PrivateLinkResourcesClient object to access its operations.
     */
    private final PrivateLinkResourcesClient privateLinkResources;

    /**
     * Gets the PrivateLinkResourcesClient object to access its operations.
     * 
     * @return the PrivateLinkResourcesClient object.
     */
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    /**
     * The ReplicasClient object to access its operations.
     */
    private final ReplicasClient replicas;

    /**
     * Gets the ReplicasClient object to access its operations.
     * 
     * @return the ReplicasClient object.
     */
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    /**
     * The LogFilesClient object to access its operations.
     */
    private final LogFilesClient logFiles;

    /**
     * Gets the LogFilesClient object to access its operations.
     * 
     * @return the LogFilesClient object.
     */
    public LogFilesClient getLogFiles() {
        return this.logFiles;
    }

    /**
     * The ServerThreatProtectionSettingsClient object to access its operations.
     */
    private final ServerThreatProtectionSettingsClient serverThreatProtectionSettings;

    /**
     * Gets the ServerThreatProtectionSettingsClient object to access its operations.
     * 
     * @return the ServerThreatProtectionSettingsClient object.
     */
    public ServerThreatProtectionSettingsClient getServerThreatProtectionSettings() {
        return this.serverThreatProtectionSettings;
    }

    /**
     * The VirtualEndpointsClient object to access its operations.
     */
    private final VirtualEndpointsClient virtualEndpoints;

    /**
     * Gets the VirtualEndpointsClient object to access its operations.
     * 
     * @return the VirtualEndpointsClient object.
     */
    public VirtualEndpointsClient getVirtualEndpoints() {
        return this.virtualEndpoints;
    }

    /**
     * The VirtualNetworkSubnetUsagesClient object to access its operations.
     */
    private final VirtualNetworkSubnetUsagesClient virtualNetworkSubnetUsages;

    /**
     * Gets the VirtualNetworkSubnetUsagesClient object to access its operations.
     * 
     * @return the VirtualNetworkSubnetUsagesClient object.
     */
    public VirtualNetworkSubnetUsagesClient getVirtualNetworkSubnetUsages() {
        return this.virtualNetworkSubnetUsages;
    }

    /**
     * Initializes an instance of PostgreSqlManagementClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param subscriptionId The ID of the target subscription. The value must be an UUID.
     * @param endpoint server parameter.
     */
    PostgreSqlManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter,
        Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2024-08-01";
        this.administrators = new AdministratorsClientImpl(this);
        this.backups = new BackupsClientImpl(this);
        this.locationBasedCapabilities = new LocationBasedCapabilitiesClientImpl(this);
        this.serverCapabilities = new ServerCapabilitiesClientImpl(this);
        this.checkNameAvailabilities = new CheckNameAvailabilitiesClientImpl(this);
        this.checkNameAvailabilityWithLocations = new CheckNameAvailabilityWithLocationsClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.firewallRules = new FirewallRulesClientImpl(this);
        this.servers = new ServersClientImpl(this);
        this.flexibleServers = new FlexibleServersClientImpl(this);
        this.ltrBackupOperations = new LtrBackupOperationsClientImpl(this);
        this.migrations = new MigrationsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.getPrivateDnsZoneSuffixes = new GetPrivateDnsZoneSuffixesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateEndpointConnectionOperations = new PrivateEndpointConnectionOperationsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.logFiles = new LogFilesClientImpl(this);
        this.serverThreatProtectionSettings = new ServerThreatProtectionSettingsClientImpl(this);
        this.virtualEndpoints = new VirtualEndpointsClientImpl(this);
        this.virtualNetworkSubnetUsages = new VirtualNetworkSubnetUsagesClientImpl(this);
    }

    /**
     * Gets default client context.
     * 
     * @return the default client context.
     */
    public Context getContext() {
        return Context.NONE;
    }

    /**
     * Merges default client context with provided context.
     * 
     * @param context the context to be merged with default client context.
     * @return the merged context.
     */
    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts(this.getContext(), context);
    }

    /**
     * Gets long running operation result.
     * 
     * @param activationResponse the response of activation operation.
     * @param httpPipeline the http pipeline.
     * @param pollResultType type of poll result.
     * @param finalResultType type of final result.
     * @param context the context shared by all requests.
     * @param <T> type of poll result.
     * @param <U> type of final result.
     * @return poller flux for poll result and final result.
     */
    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse,
        HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create(serializerAdapter, httpPipeline, pollResultType, finalResultType,
            defaultPollInterval, activationResponse, context);
    }

    /**
     * Gets the final result, or an error, based on last async poll response.
     * 
     * @param response the last async poll response.
     * @param <T> type of poll result.
     * @param <U> type of final result.
     * @return the final result, or an error.
     */
    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponse errorResponse = null;
            PollResult.Error lroError = response.getValue().getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(),
                    lroError.getResponseBody());

                errorMessage = response.getValue().getError().getMessage();
                String errorBody = response.getValue().getError().getResponseBody();
                if (errorBody != null) {
                    // try to deserialize error body to ManagementError
                    try {
                        managementError = this.getSerializerAdapter()
                            .deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    } catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning(ioe);
                    }
                }
            } else {
                // fallback to default error message
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                // fallback to default ManagementError
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error(new ManagementException(errorMessage, errorResponse, managementError));
        } else {
            return response.getFinalResult();
        }
    }

    private static final class HttpResponseImpl extends HttpResponse {
        private final int statusCode;

        private final byte[] responseBody;

        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return statusCode;
        }

        public String getHeaderValue(String s) {
            return httpHeaders.getValue(HttpHeaderName.fromString(s));
        }

        public HttpHeaders getHeaders() {
            return httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just(ByteBuffer.wrap(responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just(responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just(new String(responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just(new String(responseBody, charset));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlManagementClientImpl.class);
}
