// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionOperationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnection;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnectionOperations;

public final class PrivateEndpointConnectionOperationsImpl implements PrivateEndpointConnectionOperations {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionOperationsImpl.class);

    private final PrivateEndpointConnectionOperationsClient innerClient;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public PrivateEndpointConnectionOperationsImpl(PrivateEndpointConnectionOperationsClient innerClient,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PrivateEndpointConnection update(String resourceGroupName, String serverName,
        String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        PrivateEndpointConnectionInner inner
            = this.serviceClient().update(resourceGroupName, serverName, privateEndpointConnectionName, parameters);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PrivateEndpointConnection update(String resourceGroupName, String serverName,
        String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, Context context) {
        PrivateEndpointConnectionInner inner = this.serviceClient()
            .update(resourceGroupName, serverName, privateEndpointConnectionName, parameters, context);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void delete(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        this.serviceClient().delete(resourceGroupName, serverName, privateEndpointConnectionName);
    }

    public void delete(String resourceGroupName, String serverName, String privateEndpointConnectionName,
        Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, privateEndpointConnectionName, context);
    }

    private PrivateEndpointConnectionOperationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }
}
