// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ReplicasClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Replicas;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Server;

public final class ReplicasImpl implements Replicas {
    private static final ClientLogger LOGGER = new ClientLogger(ReplicasImpl.class);

    private final ReplicasClient innerClient;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public ReplicasImpl(ReplicasClient innerClient,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<Server> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerImpl(inner1, this.manager()));
    }

    public PagedIterable<Server> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerImpl(inner1, this.manager()));
    }

    private ReplicasClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }
}
