// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationNameAvailabilityResourceInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ResourceProvidersClient.
 */
public final class ResourceProvidersClientImpl implements ResourceProvidersClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ResourceProvidersService service;

    /**
     * The service client containing this operation class.
     */
    private final PostgreSqlManagementClientImpl client;

    /**
     * Initializes an instance of ResourceProvidersClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ResourceProvidersClientImpl(PostgreSqlManagementClientImpl client) {
        this.service
            = RestProxy.create(ResourceProvidersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PostgreSqlManagementClientResourceProviders to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PostgreSqlManagement")
    public interface ResourceProvidersService {
        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/checkMigrationNameAvailability")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MigrationNameAvailabilityResourceInner>> checkMigrationNameAvailability(
            @HostParam("$host") String endpoint, @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("targetDbServerName") String targetDbServerName,
            @BodyParam("application/json") MigrationNameAvailabilityResourceInner parameters,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MigrationNameAvailabilityResourceInner>> checkMigrationNameAvailabilityWithResponseAsync(
        String subscriptionId, String resourceGroupName, String targetDbServerName,
        MigrationNameAvailabilityResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.checkMigrationNameAvailability(this.client.getEndpoint(),
                this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, parameters, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MigrationNameAvailabilityResourceInner>> checkMigrationNameAvailabilityWithResponseAsync(
        String subscriptionId, String resourceGroupName, String targetDbServerName,
        MigrationNameAvailabilityResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMigrationNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(),
            subscriptionId, resourceGroupName, targetDbServerName, parameters, accept, context);
    }

    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MigrationNameAvailabilityResourceInner> checkMigrationNameAvailabilityAsync(String subscriptionId,
        String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters) {
        return checkMigrationNameAvailabilityWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName,
            parameters).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MigrationNameAvailabilityResourceInner> checkMigrationNameAvailabilityWithResponse(
        String subscriptionId, String resourceGroupName, String targetDbServerName,
        MigrationNameAvailabilityResourceInner parameters, Context context) {
        return checkMigrationNameAvailabilityWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName,
            parameters, context).block();
    }

    /**
     * Check migration name validity and availability
     * 
     * This method checks whether a proposed migration name is valid and available.
     * 
     * @param subscriptionId The subscription ID of the target database server.
     * @param resourceGroupName The resource group name of the target database server.
     * @param targetDbServerName The name of the target database server.
     * @param parameters The required parameters for checking if a migration name is available.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a migration name's availability.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MigrationNameAvailabilityResourceInner checkMigrationNameAvailability(String subscriptionId,
        String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters) {
        return checkMigrationNameAvailabilityWithResponse(subscriptionId, resourceGroupName, targetDbServerName,
            parameters, Context.NONE).getValue();
    }
}
