// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerThreatProtectionSettingsModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettings;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettingsModel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionName;

public final class ServerThreatProtectionSettingsImpl implements ServerThreatProtectionSettings {
    private static final ClientLogger LOGGER = new ClientLogger(ServerThreatProtectionSettingsImpl.class);

    private final ServerThreatProtectionSettingsClient innerClient;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public ServerThreatProtectionSettingsImpl(ServerThreatProtectionSettingsClient innerClient,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ServerThreatProtectionSettingsModel> listByServer(String resourceGroupName,
        String serverName) {
        PagedIterable<ServerThreatProtectionSettingsModelInner> inner
            = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ServerThreatProtectionSettingsModelImpl(inner1, this.manager()));
    }

    public PagedIterable<ServerThreatProtectionSettingsModel> listByServer(String resourceGroupName, String serverName,
        Context context) {
        PagedIterable<ServerThreatProtectionSettingsModelInner> inner
            = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new ServerThreatProtectionSettingsModelImpl(inner1, this.manager()));
    }

    public Response<ServerThreatProtectionSettingsModel> getWithResponse(String resourceGroupName, String serverName,
        ThreatProtectionName threatProtectionName, Context context) {
        Response<ServerThreatProtectionSettingsModelInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, serverName, threatProtectionName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ServerThreatProtectionSettingsModelImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ServerThreatProtectionSettingsModel get(String resourceGroupName, String serverName,
        ThreatProtectionName threatProtectionName) {
        ServerThreatProtectionSettingsModelInner inner
            = this.serviceClient().get(resourceGroupName, serverName, threatProtectionName);
        if (inner != null) {
            return new ServerThreatProtectionSettingsModelImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public ServerThreatProtectionSettingsModel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String threatProtectionNameLocal
            = ResourceManagerUtils.getValueFromIdByName(id, "advancedThreatProtectionSettings");
        if (threatProtectionNameLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format(
                "The resource ID '%s' is not valid. Missing path segment 'advancedThreatProtectionSettings'.", id)));
        }
        ThreatProtectionName threatProtectionName = ThreatProtectionName.fromString(threatProtectionNameLocal);
        return this.getWithResponse(resourceGroupName, serverName, threatProtectionName, Context.NONE).getValue();
    }

    public Response<ServerThreatProtectionSettingsModel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String threatProtectionNameLocal
            = ResourceManagerUtils.getValueFromIdByName(id, "advancedThreatProtectionSettings");
        if (threatProtectionNameLocal == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format(
                "The resource ID '%s' is not valid. Missing path segment 'advancedThreatProtectionSettings'.", id)));
        }
        ThreatProtectionName threatProtectionName = ThreatProtectionName.fromString(threatProtectionNameLocal);
        return this.getWithResponse(resourceGroupName, serverName, threatProtectionName, context);
    }

    private ServerThreatProtectionSettingsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }

    public ServerThreatProtectionSettingsModelImpl define(ThreatProtectionName name) {
        return new ServerThreatProtectionSettingsModelImpl(name, this.manager());
    }
}
