// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ServerThreatProtectionSettingsModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ServerThreatProtectionSettingsModel;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionName;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionState;
import java.time.OffsetDateTime;

public final class ServerThreatProtectionSettingsModelImpl implements ServerThreatProtectionSettingsModel,
    ServerThreatProtectionSettingsModel.Definition, ServerThreatProtectionSettingsModel.Update {
    private ServerThreatProtectionSettingsModelInner innerObject;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public String id() {
        return this.innerModel().id();
    }

    public String name() {
        return this.innerModel().name();
    }

    public String type() {
        return this.innerModel().type();
    }

    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    public ThreatProtectionState state() {
        return this.innerModel().state();
    }

    public OffsetDateTime creationTime() {
        return this.innerModel().creationTime();
    }

    public String resourceGroupName() {
        return resourceGroupName;
    }

    public ServerThreatProtectionSettingsModelInner innerModel() {
        return this.innerObject;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }

    private String resourceGroupName;

    private String serverName;

    private ThreatProtectionName threatProtectionName;

    public ServerThreatProtectionSettingsModelImpl withExistingFlexibleServer(String resourceGroupName,
        String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    public ServerThreatProtectionSettingsModel create() {
        this.innerObject = serviceManager.serviceClient()
            .getServerThreatProtectionSettings()
            .createOrUpdate(resourceGroupName, serverName, threatProtectionName, this.innerModel(), Context.NONE);
        return this;
    }

    public ServerThreatProtectionSettingsModel create(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getServerThreatProtectionSettings()
            .createOrUpdate(resourceGroupName, serverName, threatProtectionName, this.innerModel(), context);
        return this;
    }

    ServerThreatProtectionSettingsModelImpl(ThreatProtectionName name,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerObject = new ServerThreatProtectionSettingsModelInner();
        this.serviceManager = serviceManager;
        this.threatProtectionName = name;
    }

    public ServerThreatProtectionSettingsModelImpl update() {
        return this;
    }

    public ServerThreatProtectionSettingsModel apply() {
        this.innerObject = serviceManager.serviceClient()
            .getServerThreatProtectionSettings()
            .createOrUpdate(resourceGroupName, serverName, threatProtectionName, this.innerModel(), Context.NONE);
        return this;
    }

    public ServerThreatProtectionSettingsModel apply(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getServerThreatProtectionSettings()
            .createOrUpdate(resourceGroupName, serverName, threatProtectionName, this.innerModel(), context);
        return this;
    }

    ServerThreatProtectionSettingsModelImpl(ServerThreatProtectionSettingsModelInner innerObject,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.threatProtectionName = ThreatProtectionName.fromString(
            ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "advancedThreatProtectionSettings"));
    }

    public ServerThreatProtectionSettingsModel refresh() {
        this.innerObject = serviceManager.serviceClient()
            .getServerThreatProtectionSettings()
            .getWithResponse(resourceGroupName, serverName, threatProtectionName, Context.NONE)
            .getValue();
        return this;
    }

    public ServerThreatProtectionSettingsModel refresh(Context context) {
        this.innerObject = serviceManager.serviceClient()
            .getServerThreatProtectionSettings()
            .getWithResponse(resourceGroupName, serverName, threatProtectionName, context)
            .getValue();
        return this;
    }

    public ServerThreatProtectionSettingsModelImpl withState(ThreatProtectionState state) {
        this.innerModel().withState(state);
        return this;
    }
}
