// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualEndpointsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpoints;

public final class VirtualEndpointsImpl implements VirtualEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualEndpointsImpl.class);

    private final VirtualEndpointsClient innerClient;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public VirtualEndpointsImpl(VirtualEndpointsClient innerClient,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public void delete(String resourceGroupName, String serverName, String virtualEndpointName) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualEndpointName);
    }

    public void delete(String resourceGroupName, String serverName, String virtualEndpointName, Context context) {
        this.serviceClient().delete(resourceGroupName, serverName, virtualEndpointName, context);
    }

    public Response<VirtualEndpointResource> getWithResponse(String resourceGroupName, String serverName,
        String virtualEndpointName, Context context) {
        Response<VirtualEndpointResourceInner> inner
            = this.serviceClient().getWithResponse(resourceGroupName, serverName, virtualEndpointName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new VirtualEndpointResourceImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public VirtualEndpointResource get(String resourceGroupName, String serverName, String virtualEndpointName) {
        VirtualEndpointResourceInner inner
            = this.serviceClient().get(resourceGroupName, serverName, virtualEndpointName);
        if (inner != null) {
            return new VirtualEndpointResourceImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public PagedIterable<VirtualEndpointResource> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<VirtualEndpointResourceInner> inner
            = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualEndpointResourceImpl(inner1, this.manager()));
    }

    public PagedIterable<VirtualEndpointResource> listByServer(String resourceGroupName, String serverName,
        Context context) {
        PagedIterable<VirtualEndpointResourceInner> inner
            = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualEndpointResourceImpl(inner1, this.manager()));
    }

    public VirtualEndpointResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, virtualEndpointName, Context.NONE).getValue();
    }

    public Response<VirtualEndpointResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, virtualEndpointName, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualEndpointName, Context.NONE);
    }

    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = ResourceManagerUtils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String virtualEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "virtualendpoints");
        if (virtualEndpointName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'virtualendpoints'.", id)));
        }
        this.delete(resourceGroupName, serverName, virtualEndpointName, context);
    }

    private VirtualEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }

    public VirtualEndpointResourceImpl define(String name) {
        return new VirtualEndpointResourceImpl(name, this.manager());
    }
}
