// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.VirtualNetworkSubnetUsagesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualNetworkSubnetUsageResultInner;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsageParameter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsageResult;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualNetworkSubnetUsages;

public final class VirtualNetworkSubnetUsagesImpl implements VirtualNetworkSubnetUsages {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkSubnetUsagesImpl.class);

    private final VirtualNetworkSubnetUsagesClient innerClient;

    private final com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager;

    public VirtualNetworkSubnetUsagesImpl(VirtualNetworkSubnetUsagesClient innerClient,
        com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<VirtualNetworkSubnetUsageResult> executeWithResponse(String locationName,
        VirtualNetworkSubnetUsageParameter parameters, Context context) {
        Response<VirtualNetworkSubnetUsageResultInner> inner
            = this.serviceClient().executeWithResponse(locationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new VirtualNetworkSubnetUsageResultImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public VirtualNetworkSubnetUsageResult execute(String locationName, VirtualNetworkSubnetUsageParameter parameters) {
        VirtualNetworkSubnetUsageResultInner inner = this.serviceClient().execute(locationName, parameters);
        if (inner != null) {
            return new VirtualNetworkSubnetUsageResultImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private VirtualNetworkSubnetUsagesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager manager() {
        return this.serviceManager;
    }
}
