// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.AdministratorPropertiesForAdd;
import java.io.IOException;

/**
 * Represents an Active Directory administrator.
 */
@Fluent
public final class ActiveDirectoryAdministratorAdd implements JsonSerializable<ActiveDirectoryAdministratorAdd> {
    /*
     * Properties of the active directory administrator.
     */
    private AdministratorPropertiesForAdd innerProperties;

    /**
     * Creates an instance of ActiveDirectoryAdministratorAdd class.
     */
    public ActiveDirectoryAdministratorAdd() {
    }

    /**
     * Get the innerProperties property: Properties of the active directory administrator.
     * 
     * @return the innerProperties value.
     */
    private AdministratorPropertiesForAdd innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the principalType property: The principal type used to represent the type of Active Directory Administrator.
     * 
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    /**
     * Set the principalType property: The principal type used to represent the type of Active Directory Administrator.
     * 
     * @param principalType the principalType value to set.
     * @return the ActiveDirectoryAdministratorAdd object itself.
     */
    public ActiveDirectoryAdministratorAdd withPrincipalType(PrincipalType principalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorPropertiesForAdd();
        }
        this.innerProperties().withPrincipalType(principalType);
        return this;
    }

    /**
     * Get the principalName property: Active Directory administrator principal name.
     * 
     * @return the principalName value.
     */
    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    /**
     * Set the principalName property: Active Directory administrator principal name.
     * 
     * @param principalName the principalName value to set.
     * @return the ActiveDirectoryAdministratorAdd object itself.
     */
    public ActiveDirectoryAdministratorAdd withPrincipalName(String principalName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorPropertiesForAdd();
        }
        this.innerProperties().withPrincipalName(principalName);
        return this;
    }

    /**
     * Get the tenantId property: The tenantId of the Active Directory administrator.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    /**
     * Set the tenantId property: The tenantId of the Active Directory administrator.
     * 
     * @param tenantId the tenantId value to set.
     * @return the ActiveDirectoryAdministratorAdd object itself.
     */
    public ActiveDirectoryAdministratorAdd withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdministratorPropertiesForAdd();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActiveDirectoryAdministratorAdd from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActiveDirectoryAdministratorAdd if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ActiveDirectoryAdministratorAdd.
     */
    public static ActiveDirectoryAdministratorAdd fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActiveDirectoryAdministratorAdd deserializedActiveDirectoryAdministratorAdd
                = new ActiveDirectoryAdministratorAdd();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedActiveDirectoryAdministratorAdd.innerProperties
                        = AdministratorPropertiesForAdd.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActiveDirectoryAdministratorAdd;
        });
    }
}
