// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Server admin credentials.
 */
@Fluent
public final class AdminCredentials implements JsonSerializable<AdminCredentials> {
    /*
     * Password for source server.
     */
    private String sourceServerPassword;

    /*
     * Password for target server.
     */
    private String targetServerPassword;

    /**
     * Creates an instance of AdminCredentials class.
     */
    public AdminCredentials() {
    }

    /**
     * Get the sourceServerPassword property: Password for source server.
     * 
     * @return the sourceServerPassword value.
     */
    public String sourceServerPassword() {
        return this.sourceServerPassword;
    }

    /**
     * Set the sourceServerPassword property: Password for source server.
     * 
     * @param sourceServerPassword the sourceServerPassword value to set.
     * @return the AdminCredentials object itself.
     */
    public AdminCredentials withSourceServerPassword(String sourceServerPassword) {
        this.sourceServerPassword = sourceServerPassword;
        return this;
    }

    /**
     * Get the targetServerPassword property: Password for target server.
     * 
     * @return the targetServerPassword value.
     */
    public String targetServerPassword() {
        return this.targetServerPassword;
    }

    /**
     * Set the targetServerPassword property: Password for target server.
     * 
     * @param targetServerPassword the targetServerPassword value to set.
     * @return the AdminCredentials object itself.
     */
    public AdminCredentials withTargetServerPassword(String targetServerPassword) {
        this.targetServerPassword = targetServerPassword;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceServerPassword() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceServerPassword in model AdminCredentials"));
        }
        if (targetServerPassword() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property targetServerPassword in model AdminCredentials"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AdminCredentials.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceServerPassword", this.sourceServerPassword);
        jsonWriter.writeStringField("targetServerPassword", this.targetServerPassword);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AdminCredentials from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AdminCredentials if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AdminCredentials.
     */
    public static AdminCredentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AdminCredentials deserializedAdminCredentials = new AdminCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceServerPassword".equals(fieldName)) {
                    deserializedAdminCredentials.sourceServerPassword = reader.getString();
                } else if ("targetServerPassword".equals(fieldName)) {
                    deserializedAdminCredentials.targetServerPassword = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAdminCredentials;
        });
    }
}
