// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Data encryption type to depict if it is System Managed vs Azure Key vault.
 */
public final class ArmServerKeyType extends ExpandableStringEnum<ArmServerKeyType> {
    /**
     * Static value SystemManaged for ArmServerKeyType.
     */
    public static final ArmServerKeyType SYSTEM_MANAGED = fromString("SystemManaged");

    /**
     * Static value AzureKeyVault for ArmServerKeyType.
     */
    public static final ArmServerKeyType AZURE_KEY_VAULT = fromString("AzureKeyVault");

    /**
     * Creates a new instance of ArmServerKeyType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ArmServerKeyType() {
    }

    /**
     * Creates or finds a ArmServerKeyType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ArmServerKeyType.
     */
    public static ArmServerKeyType fromString(String name) {
        return fromString(name, ArmServerKeyType.class);
    }

    /**
     * Gets known ArmServerKeyType values.
     * 
     * @return known ArmServerKeyType values.
     */
    public static Collection<ArmServerKeyType> values() {
        return values(ArmServerKeyType.class);
    }
}
