// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ConfigurationProperties;
import java.io.IOException;

/**
 * Represents a Configuration.
 */
@Fluent
public final class ConfigurationForUpdate implements JsonSerializable<ConfigurationForUpdate> {
    /*
     * The properties of a configuration.
     */
    private ConfigurationProperties innerProperties;

    /**
     * Creates an instance of ConfigurationForUpdate class.
     */
    public ConfigurationForUpdate() {
    }

    /**
     * Get the innerProperties property: The properties of a configuration.
     * 
     * @return the innerProperties value.
     */
    private ConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the value property: Value of the configuration. Required to update the configuration.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: Value of the configuration. Required to update the configuration.
     * 
     * @param value the value value to set.
     * @return the ConfigurationForUpdate object itself.
     */
    public ConfigurationForUpdate withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Get the description property: Description of the configuration.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Get the defaultValue property: Default value of the configuration.
     * 
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultValue();
    }

    /**
     * Get the dataType property: Data type of the configuration.
     * 
     * @return the dataType value.
     */
    public ConfigurationDataType dataType() {
        return this.innerProperties() == null ? null : this.innerProperties().dataType();
    }

    /**
     * Get the allowedValues property: Allowed values of the configuration.
     * 
     * @return the allowedValues value.
     */
    public String allowedValues() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedValues();
    }

    /**
     * Get the source property: Source of the configuration. Required to update the configuration.
     * 
     * @return the source value.
     */
    public String source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    /**
     * Set the source property: Source of the configuration. Required to update the configuration.
     * 
     * @param source the source value to set.
     * @return the ConfigurationForUpdate object itself.
     */
    public ConfigurationForUpdate withSource(String source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    /**
     * Get the isDynamicConfig property: Configuration dynamic or static.
     * 
     * @return the isDynamicConfig value.
     */
    public Boolean isDynamicConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().isDynamicConfig();
    }

    /**
     * Get the isReadOnly property: Configuration read-only or not.
     * 
     * @return the isReadOnly value.
     */
    public Boolean isReadOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().isReadOnly();
    }

    /**
     * Get the isConfigPendingRestart property: Configuration is pending restart or not.
     * 
     * @return the isConfigPendingRestart value.
     */
    public Boolean isConfigPendingRestart() {
        return this.innerProperties() == null ? null : this.innerProperties().isConfigPendingRestart();
    }

    /**
     * Get the unit property: Configuration unit.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.innerProperties() == null ? null : this.innerProperties().unit();
    }

    /**
     * Get the documentationLink property: Configuration documentation link.
     * 
     * @return the documentationLink value.
     */
    public String documentationLink() {
        return this.innerProperties() == null ? null : this.innerProperties().documentationLink();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationForUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationForUpdate if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationForUpdate.
     */
    public static ConfigurationForUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationForUpdate deserializedConfigurationForUpdate = new ConfigurationForUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedConfigurationForUpdate.innerProperties = ConfigurationProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationForUpdate;
        });
    }
}
