// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ConfigurationInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of server configurations.
 */
@Fluent
public final class ConfigurationListResult implements JsonSerializable<ConfigurationListResult> {
    /*
     * The list of server configurations.
     */
    private List<ConfigurationInner> value;

    /*
     * The link used to get the next page of operations.
     */
    private String nextLink;

    /**
     * Creates an instance of ConfigurationListResult class.
     */
    public ConfigurationListResult() {
    }

    /**
     * Get the value property: The list of server configurations.
     * 
     * @return the value value.
     */
    public List<ConfigurationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of server configurations.
     * 
     * @param value the value value to set.
     * @return the ConfigurationListResult object itself.
     */
    public ConfigurationListResult withValue(List<ConfigurationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link used to get the next page of operations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of operations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ConfigurationListResult object itself.
     */
    public ConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfigurationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfigurationListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfigurationListResult.
     */
    public static ConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfigurationListResult deserializedConfigurationListResult = new ConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ConfigurationInner> value = reader.readArray(reader1 -> ConfigurationInner.fromJson(reader1));
                    deserializedConfigurationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedConfigurationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfigurationListResult;
        });
    }
}
