// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The mode to create a new PostgreSQL server.
 */
public final class CreateMode extends ExpandableStringEnum<CreateMode> {
    /**
     * Static value Default for CreateMode.
     */
    public static final CreateMode DEFAULT = fromString("Default");

    /**
     * Static value Create for CreateMode.
     */
    public static final CreateMode CREATE = fromString("Create");

    /**
     * Static value Update for CreateMode.
     */
    public static final CreateMode UPDATE = fromString("Update");

    /**
     * Static value PointInTimeRestore for CreateMode.
     */
    public static final CreateMode POINT_IN_TIME_RESTORE = fromString("PointInTimeRestore");

    /**
     * Static value GeoRestore for CreateMode.
     */
    public static final CreateMode GEO_RESTORE = fromString("GeoRestore");

    /**
     * Static value Replica for CreateMode.
     */
    public static final CreateMode REPLICA = fromString("Replica");

    /**
     * Static value ReviveDropped for CreateMode.
     */
    public static final CreateMode REVIVE_DROPPED = fromString("ReviveDropped");

    /**
     * Creates a new instance of CreateMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public CreateMode() {
    }

    /**
     * Creates or finds a CreateMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding CreateMode.
     */
    public static CreateMode fromString(String name) {
        return fromString(name, CreateMode.class);
    }

    /**
     * Gets known CreateMode values.
     * 
     * @return known CreateMode values.
     */
    public static Collection<CreateMode> values() {
        return values(CreateMode.class);
    }
}
