// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Validation status summary for an individual database.
 */
@Fluent
public final class DbLevelValidationStatus implements JsonSerializable<DbLevelValidationStatus> {
    /*
     * Name of the database
     */
    private String databaseName;

    /*
     * Start date-time of a database level validation
     */
    private OffsetDateTime startedOn;

    /*
     * End date-time of a database level validation
     */
    private OffsetDateTime endedOn;

    /*
     * Summary of database level validations
     */
    private List<ValidationSummaryItem> summary;

    /**
     * Creates an instance of DbLevelValidationStatus class.
     */
    public DbLevelValidationStatus() {
    }

    /**
     * Get the databaseName property: Name of the database.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: Name of the database.
     * 
     * @param databaseName the databaseName value to set.
     * @return the DbLevelValidationStatus object itself.
     */
    public DbLevelValidationStatus withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the startedOn property: Start date-time of a database level validation.
     * 
     * @return the startedOn value.
     */
    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    /**
     * Set the startedOn property: Start date-time of a database level validation.
     * 
     * @param startedOn the startedOn value to set.
     * @return the DbLevelValidationStatus object itself.
     */
    public DbLevelValidationStatus withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    /**
     * Get the endedOn property: End date-time of a database level validation.
     * 
     * @return the endedOn value.
     */
    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    /**
     * Set the endedOn property: End date-time of a database level validation.
     * 
     * @param endedOn the endedOn value to set.
     * @return the DbLevelValidationStatus object itself.
     */
    public DbLevelValidationStatus withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    /**
     * Get the summary property: Summary of database level validations.
     * 
     * @return the summary value.
     */
    public List<ValidationSummaryItem> summary() {
        return this.summary;
    }

    /**
     * Set the summary property: Summary of database level validations.
     * 
     * @param summary the summary value to set.
     * @return the DbLevelValidationStatus object itself.
     */
    public DbLevelValidationStatus withSummary(List<ValidationSummaryItem> summary) {
        this.summary = summary;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (summary() != null) {
            summary().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("startedOn",
            this.startedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedOn));
        jsonWriter.writeStringField("endedOn",
            this.endedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endedOn));
        jsonWriter.writeArrayField("summary", this.summary, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DbLevelValidationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DbLevelValidationStatus if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DbLevelValidationStatus.
     */
    public static DbLevelValidationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DbLevelValidationStatus deserializedDbLevelValidationStatus = new DbLevelValidationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseName".equals(fieldName)) {
                    deserializedDbLevelValidationStatus.databaseName = reader.getString();
                } else if ("startedOn".equals(fieldName)) {
                    deserializedDbLevelValidationStatus.startedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endedOn".equals(fieldName)) {
                    deserializedDbLevelValidationStatus.endedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("summary".equals(fieldName)) {
                    List<ValidationSummaryItem> summary
                        = reader.readArray(reader1 -> ValidationSummaryItem.fromJson(reader1));
                    deserializedDbLevelValidationStatus.summary = summary;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDbLevelValidationStatus;
        });
    }
}
