// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Migration status of an individual database.
 */
@Fluent
public final class DbMigrationStatus implements JsonSerializable<DbMigrationStatus> {
    /*
     * Name of the database
     */
    private String databaseName;

    /*
     * Migration db state of an individual database
     */
    private MigrationDbState migrationState;

    /*
     * Migration operation of an individual database
     */
    private String migrationOperation;

    /*
     * Start date-time of a migration state
     */
    private OffsetDateTime startedOn;

    /*
     * End date-time of a migration state
     */
    private OffsetDateTime endedOn;

    /*
     * Number of tables queued for the migration of a DB
     */
    private Integer fullLoadQueuedTables;

    /*
     * Number of tables errored out during the migration of a DB
     */
    private Integer fullLoadErroredTables;

    /*
     * Number of tables loading during the migration of a DB
     */
    private Integer fullLoadLoadingTables;

    /*
     * Number of tables loaded during the migration of a DB
     */
    private Integer fullLoadCompletedTables;

    /*
     * CDC update counter
     */
    private Integer cdcUpdateCounter;

    /*
     * CDC delete counter
     */
    private Integer cdcDeleteCounter;

    /*
     * CDC insert counter
     */
    private Integer cdcInsertCounter;

    /*
     * CDC applied changes counter
     */
    private Integer appliedChanges;

    /*
     * CDC incoming changes counter
     */
    private Integer incomingChanges;

    /*
     * Lag in seconds between source and target during online phase
     */
    private Integer latency;

    /*
     * Error message, if any, for the migration state
     */
    private String message;

    /**
     * Creates an instance of DbMigrationStatus class.
     */
    public DbMigrationStatus() {
    }

    /**
     * Get the databaseName property: Name of the database.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: Name of the database.
     * 
     * @param databaseName the databaseName value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the migrationState property: Migration db state of an individual database.
     * 
     * @return the migrationState value.
     */
    public MigrationDbState migrationState() {
        return this.migrationState;
    }

    /**
     * Set the migrationState property: Migration db state of an individual database.
     * 
     * @param migrationState the migrationState value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withMigrationState(MigrationDbState migrationState) {
        this.migrationState = migrationState;
        return this;
    }

    /**
     * Get the migrationOperation property: Migration operation of an individual database.
     * 
     * @return the migrationOperation value.
     */
    public String migrationOperation() {
        return this.migrationOperation;
    }

    /**
     * Set the migrationOperation property: Migration operation of an individual database.
     * 
     * @param migrationOperation the migrationOperation value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withMigrationOperation(String migrationOperation) {
        this.migrationOperation = migrationOperation;
        return this;
    }

    /**
     * Get the startedOn property: Start date-time of a migration state.
     * 
     * @return the startedOn value.
     */
    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    /**
     * Set the startedOn property: Start date-time of a migration state.
     * 
     * @param startedOn the startedOn value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    /**
     * Get the endedOn property: End date-time of a migration state.
     * 
     * @return the endedOn value.
     */
    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    /**
     * Set the endedOn property: End date-time of a migration state.
     * 
     * @param endedOn the endedOn value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    /**
     * Get the fullLoadQueuedTables property: Number of tables queued for the migration of a DB.
     * 
     * @return the fullLoadQueuedTables value.
     */
    public Integer fullLoadQueuedTables() {
        return this.fullLoadQueuedTables;
    }

    /**
     * Set the fullLoadQueuedTables property: Number of tables queued for the migration of a DB.
     * 
     * @param fullLoadQueuedTables the fullLoadQueuedTables value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withFullLoadQueuedTables(Integer fullLoadQueuedTables) {
        this.fullLoadQueuedTables = fullLoadQueuedTables;
        return this;
    }

    /**
     * Get the fullLoadErroredTables property: Number of tables errored out during the migration of a DB.
     * 
     * @return the fullLoadErroredTables value.
     */
    public Integer fullLoadErroredTables() {
        return this.fullLoadErroredTables;
    }

    /**
     * Set the fullLoadErroredTables property: Number of tables errored out during the migration of a DB.
     * 
     * @param fullLoadErroredTables the fullLoadErroredTables value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withFullLoadErroredTables(Integer fullLoadErroredTables) {
        this.fullLoadErroredTables = fullLoadErroredTables;
        return this;
    }

    /**
     * Get the fullLoadLoadingTables property: Number of tables loading during the migration of a DB.
     * 
     * @return the fullLoadLoadingTables value.
     */
    public Integer fullLoadLoadingTables() {
        return this.fullLoadLoadingTables;
    }

    /**
     * Set the fullLoadLoadingTables property: Number of tables loading during the migration of a DB.
     * 
     * @param fullLoadLoadingTables the fullLoadLoadingTables value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withFullLoadLoadingTables(Integer fullLoadLoadingTables) {
        this.fullLoadLoadingTables = fullLoadLoadingTables;
        return this;
    }

    /**
     * Get the fullLoadCompletedTables property: Number of tables loaded during the migration of a DB.
     * 
     * @return the fullLoadCompletedTables value.
     */
    public Integer fullLoadCompletedTables() {
        return this.fullLoadCompletedTables;
    }

    /**
     * Set the fullLoadCompletedTables property: Number of tables loaded during the migration of a DB.
     * 
     * @param fullLoadCompletedTables the fullLoadCompletedTables value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withFullLoadCompletedTables(Integer fullLoadCompletedTables) {
        this.fullLoadCompletedTables = fullLoadCompletedTables;
        return this;
    }

    /**
     * Get the cdcUpdateCounter property: CDC update counter.
     * 
     * @return the cdcUpdateCounter value.
     */
    public Integer cdcUpdateCounter() {
        return this.cdcUpdateCounter;
    }

    /**
     * Set the cdcUpdateCounter property: CDC update counter.
     * 
     * @param cdcUpdateCounter the cdcUpdateCounter value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withCdcUpdateCounter(Integer cdcUpdateCounter) {
        this.cdcUpdateCounter = cdcUpdateCounter;
        return this;
    }

    /**
     * Get the cdcDeleteCounter property: CDC delete counter.
     * 
     * @return the cdcDeleteCounter value.
     */
    public Integer cdcDeleteCounter() {
        return this.cdcDeleteCounter;
    }

    /**
     * Set the cdcDeleteCounter property: CDC delete counter.
     * 
     * @param cdcDeleteCounter the cdcDeleteCounter value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withCdcDeleteCounter(Integer cdcDeleteCounter) {
        this.cdcDeleteCounter = cdcDeleteCounter;
        return this;
    }

    /**
     * Get the cdcInsertCounter property: CDC insert counter.
     * 
     * @return the cdcInsertCounter value.
     */
    public Integer cdcInsertCounter() {
        return this.cdcInsertCounter;
    }

    /**
     * Set the cdcInsertCounter property: CDC insert counter.
     * 
     * @param cdcInsertCounter the cdcInsertCounter value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withCdcInsertCounter(Integer cdcInsertCounter) {
        this.cdcInsertCounter = cdcInsertCounter;
        return this;
    }

    /**
     * Get the appliedChanges property: CDC applied changes counter.
     * 
     * @return the appliedChanges value.
     */
    public Integer appliedChanges() {
        return this.appliedChanges;
    }

    /**
     * Set the appliedChanges property: CDC applied changes counter.
     * 
     * @param appliedChanges the appliedChanges value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withAppliedChanges(Integer appliedChanges) {
        this.appliedChanges = appliedChanges;
        return this;
    }

    /**
     * Get the incomingChanges property: CDC incoming changes counter.
     * 
     * @return the incomingChanges value.
     */
    public Integer incomingChanges() {
        return this.incomingChanges;
    }

    /**
     * Set the incomingChanges property: CDC incoming changes counter.
     * 
     * @param incomingChanges the incomingChanges value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withIncomingChanges(Integer incomingChanges) {
        this.incomingChanges = incomingChanges;
        return this;
    }

    /**
     * Get the latency property: Lag in seconds between source and target during online phase.
     * 
     * @return the latency value.
     */
    public Integer latency() {
        return this.latency;
    }

    /**
     * Set the latency property: Lag in seconds between source and target during online phase.
     * 
     * @param latency the latency value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withLatency(Integer latency) {
        this.latency = latency;
        return this;
    }

    /**
     * Get the message property: Error message, if any, for the migration state.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Error message, if any, for the migration state.
     * 
     * @param message the message value to set.
     * @return the DbMigrationStatus object itself.
     */
    public DbMigrationStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("migrationState",
            this.migrationState == null ? null : this.migrationState.toString());
        jsonWriter.writeStringField("migrationOperation", this.migrationOperation);
        jsonWriter.writeStringField("startedOn",
            this.startedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startedOn));
        jsonWriter.writeStringField("endedOn",
            this.endedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endedOn));
        jsonWriter.writeNumberField("fullLoadQueuedTables", this.fullLoadQueuedTables);
        jsonWriter.writeNumberField("fullLoadErroredTables", this.fullLoadErroredTables);
        jsonWriter.writeNumberField("fullLoadLoadingTables", this.fullLoadLoadingTables);
        jsonWriter.writeNumberField("fullLoadCompletedTables", this.fullLoadCompletedTables);
        jsonWriter.writeNumberField("cdcUpdateCounter", this.cdcUpdateCounter);
        jsonWriter.writeNumberField("cdcDeleteCounter", this.cdcDeleteCounter);
        jsonWriter.writeNumberField("cdcInsertCounter", this.cdcInsertCounter);
        jsonWriter.writeNumberField("appliedChanges", this.appliedChanges);
        jsonWriter.writeNumberField("incomingChanges", this.incomingChanges);
        jsonWriter.writeNumberField("latency", this.latency);
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DbMigrationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DbMigrationStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DbMigrationStatus.
     */
    public static DbMigrationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DbMigrationStatus deserializedDbMigrationStatus = new DbMigrationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("databaseName".equals(fieldName)) {
                    deserializedDbMigrationStatus.databaseName = reader.getString();
                } else if ("migrationState".equals(fieldName)) {
                    deserializedDbMigrationStatus.migrationState = MigrationDbState.fromString(reader.getString());
                } else if ("migrationOperation".equals(fieldName)) {
                    deserializedDbMigrationStatus.migrationOperation = reader.getString();
                } else if ("startedOn".equals(fieldName)) {
                    deserializedDbMigrationStatus.startedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endedOn".equals(fieldName)) {
                    deserializedDbMigrationStatus.endedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("fullLoadQueuedTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadQueuedTables = reader.getNullable(JsonReader::getInt);
                } else if ("fullLoadErroredTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadErroredTables = reader.getNullable(JsonReader::getInt);
                } else if ("fullLoadLoadingTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadLoadingTables = reader.getNullable(JsonReader::getInt);
                } else if ("fullLoadCompletedTables".equals(fieldName)) {
                    deserializedDbMigrationStatus.fullLoadCompletedTables = reader.getNullable(JsonReader::getInt);
                } else if ("cdcUpdateCounter".equals(fieldName)) {
                    deserializedDbMigrationStatus.cdcUpdateCounter = reader.getNullable(JsonReader::getInt);
                } else if ("cdcDeleteCounter".equals(fieldName)) {
                    deserializedDbMigrationStatus.cdcDeleteCounter = reader.getNullable(JsonReader::getInt);
                } else if ("cdcInsertCounter".equals(fieldName)) {
                    deserializedDbMigrationStatus.cdcInsertCounter = reader.getNullable(JsonReader::getInt);
                } else if ("appliedChanges".equals(fieldName)) {
                    deserializedDbMigrationStatus.appliedChanges = reader.getNullable(JsonReader::getInt);
                } else if ("incomingChanges".equals(fieldName)) {
                    deserializedDbMigrationStatus.incomingChanges = reader.getNullable(JsonReader::getInt);
                } else if ("latency".equals(fieldName)) {
                    deserializedDbMigrationStatus.latency = reader.getNullable(JsonReader::getInt);
                } else if ("message".equals(fieldName)) {
                    deserializedDbMigrationStatus.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDbMigrationStatus;
        });
    }
}
