// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Database server metadata.
 */
@Fluent
public final class DbServerMetadata implements JsonSerializable<DbServerMetadata> {
    /*
     * Location of database server
     */
    private String location;

    /*
     * Version for database engine
     */
    private String version;

    /*
     * Storage size in MB for database server
     */
    private Integer storageMb;

    /*
     * SKU for the database server. This object is empty for PG single server
     */
    private ServerSku sku;

    /**
     * Creates an instance of DbServerMetadata class.
     */
    public DbServerMetadata() {
    }

    /**
     * Get the location property: Location of database server.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the version property: Version for database engine.
     * 
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version property: Version for database engine.
     * 
     * @param version the version value to set.
     * @return the DbServerMetadata object itself.
     */
    public DbServerMetadata withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the storageMb property: Storage size in MB for database server.
     * 
     * @return the storageMb value.
     */
    public Integer storageMb() {
        return this.storageMb;
    }

    /**
     * Set the storageMb property: Storage size in MB for database server.
     * 
     * @param storageMb the storageMb value to set.
     * @return the DbServerMetadata object itself.
     */
    public DbServerMetadata withStorageMb(Integer storageMb) {
        this.storageMb = storageMb;
        return this;
    }

    /**
     * Get the sku property: SKU for the database server. This object is empty for PG single server.
     * 
     * @return the sku value.
     */
    public ServerSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU for the database server. This object is empty for PG single server.
     * 
     * @param sku the sku value to set.
     * @return the DbServerMetadata object itself.
     */
    public DbServerMetadata withSku(ServerSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() != null) {
            sku().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeNumberField("storageMb", this.storageMb);
        jsonWriter.writeJsonField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DbServerMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DbServerMetadata if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DbServerMetadata.
     */
    public static DbServerMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DbServerMetadata deserializedDbServerMetadata = new DbServerMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedDbServerMetadata.location = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedDbServerMetadata.version = reader.getString();
                } else if ("storageMb".equals(fieldName)) {
                    deserializedDbServerMetadata.storageMb = reader.getNullable(JsonReader::getInt);
                } else if ("sku".equals(fieldName)) {
                    deserializedDbServerMetadata.sku = ServerSku.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDbServerMetadata;
        });
    }
}
