// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Delegated subnet usage data.
 */
@Immutable
public final class DelegatedSubnetUsage implements JsonSerializable<DelegatedSubnetUsage> {
    /*
     * Name of the delegated subnet for which IP addresses are in use
     */
    private String subnetName;

    /*
     * Number of IP addresses used by the delegated subnet
     */
    private Long usage;

    /**
     * Creates an instance of DelegatedSubnetUsage class.
     */
    public DelegatedSubnetUsage() {
    }

    /**
     * Get the subnetName property: Name of the delegated subnet for which IP addresses are in use.
     * 
     * @return the subnetName value.
     */
    public String subnetName() {
        return this.subnetName;
    }

    /**
     * Get the usage property: Number of IP addresses used by the delegated subnet.
     * 
     * @return the usage value.
     */
    public Long usage() {
        return this.usage;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DelegatedSubnetUsage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DelegatedSubnetUsage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DelegatedSubnetUsage.
     */
    public static DelegatedSubnetUsage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DelegatedSubnetUsage deserializedDelegatedSubnetUsage = new DelegatedSubnetUsage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnetName".equals(fieldName)) {
                    deserializedDelegatedSubnetUsage.subnetName = reader.getString();
                } else if ("usage".equals(fieldName)) {
                    deserializedDelegatedSubnetUsage.usage = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDelegatedSubnetUsage;
        });
    }
}
