// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Service-set extensible enum indicating the status of operation.
 */
public final class ExecutionStatus extends ExpandableStringEnum<ExecutionStatus> {
    /**
     * Static value Running for ExecutionStatus.
     */
    public static final ExecutionStatus RUNNING = fromString("Running");

    /**
     * Static value Cancelled for ExecutionStatus.
     */
    public static final ExecutionStatus CANCELLED = fromString("Cancelled");

    /**
     * Static value Failed for ExecutionStatus.
     */
    public static final ExecutionStatus FAILED = fromString("Failed");

    /**
     * Static value Succeeded for ExecutionStatus.
     */
    public static final ExecutionStatus SUCCEEDED = fromString("Succeeded");

    /**
     * Creates a new instance of ExecutionStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ExecutionStatus() {
    }

    /**
     * Creates or finds a ExecutionStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ExecutionStatus.
     */
    public static ExecutionStatus fromString(String name) {
        return fromString(name, ExecutionStatus.class);
    }

    /**
     * Gets known ExecutionStatus values.
     * 
     * @return known ExecutionStatus values.
     */
    public static Collection<ExecutionStatus> values() {
        return values(ExecutionStatus.class);
    }
}
