// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents capability of a fast provisioning edition.
 */
@Immutable
public final class FastProvisioningEditionCapability extends CapabilityBase {
    /*
     * Fast provisioning supported tier name
     */
    private String supportedTier;

    /*
     * Fast provisioning supported sku name
     */
    private String supportedSku;

    /*
     * Fast provisioning supported storage in Gb
     */
    private Integer supportedStorageGb;

    /*
     * Fast provisioning supported version
     */
    private String supportedServerVersions;

    /*
     * Count of servers in cache matching the spec
     */
    private Integer serverCount;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /**
     * Creates an instance of FastProvisioningEditionCapability class.
     */
    public FastProvisioningEditionCapability() {
    }

    /**
     * Get the supportedTier property: Fast provisioning supported tier name.
     * 
     * @return the supportedTier value.
     */
    public String supportedTier() {
        return this.supportedTier;
    }

    /**
     * Get the supportedSku property: Fast provisioning supported sku name.
     * 
     * @return the supportedSku value.
     */
    public String supportedSku() {
        return this.supportedSku;
    }

    /**
     * Get the supportedStorageGb property: Fast provisioning supported storage in Gb.
     * 
     * @return the supportedStorageGb value.
     */
    public Integer supportedStorageGb() {
        return this.supportedStorageGb;
    }

    /**
     * Get the supportedServerVersions property: Fast provisioning supported version.
     * 
     * @return the supportedServerVersions value.
     */
    public String supportedServerVersions() {
        return this.supportedServerVersions;
    }

    /**
     * Get the serverCount property: Count of servers in cache matching the spec.
     * 
     * @return the serverCount value.
     */
    public Integer serverCount() {
        return this.serverCount;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    @Override
    public String reason() {
        return this.reason;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FastProvisioningEditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FastProvisioningEditionCapability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FastProvisioningEditionCapability.
     */
    public static FastProvisioningEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FastProvisioningEditionCapability deserializedFastProvisioningEditionCapability
                = new FastProvisioningEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.reason = reader.getString();
                } else if ("supportedTier".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.supportedTier = reader.getString();
                } else if ("supportedSku".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.supportedSku = reader.getString();
                } else if ("supportedStorageGb".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.supportedStorageGb
                        = reader.getNullable(JsonReader::getInt);
                } else if ("supportedServerVersions".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.supportedServerVersions = reader.getString();
                } else if ("serverCount".equals(fieldName)) {
                    deserializedFastProvisioningEditionCapability.serverCount = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFastProvisioningEditionCapability;
        });
    }
}
