// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.FirewallRuleInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of firewall rules.
 */
@Fluent
public final class FirewallRuleListResult implements JsonSerializable<FirewallRuleListResult> {
    /*
     * The list of firewall rules in a server.
     */
    private List<FirewallRuleInner> value;

    /*
     * The link used to get the next page of operations.
     */
    private String nextLink;

    /**
     * Creates an instance of FirewallRuleListResult class.
     */
    public FirewallRuleListResult() {
    }

    /**
     * Get the value property: The list of firewall rules in a server.
     * 
     * @return the value value.
     */
    public List<FirewallRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of firewall rules in a server.
     * 
     * @param value the value value to set.
     * @return the FirewallRuleListResult object itself.
     */
    public FirewallRuleListResult withValue(List<FirewallRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The link used to get the next page of operations.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of operations.
     * 
     * @param nextLink the nextLink value to set.
     * @return the FirewallRuleListResult object itself.
     */
    public FirewallRuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FirewallRuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FirewallRuleListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FirewallRuleListResult.
     */
    public static FirewallRuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FirewallRuleListResult deserializedFirewallRuleListResult = new FirewallRuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<FirewallRuleInner> value = reader.readArray(reader1 -> FirewallRuleInner.fromJson(reader1));
                    deserializedFirewallRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedFirewallRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFirewallRuleListResult;
        });
    }
}
