// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.FlexibleServerCapabilityInner;
import java.util.List;

/**
 * An immutable client-side representation of FlexibleServerCapability.
 */
public interface FlexibleServerCapability {
    /**
     * Gets the status property: The status of the capability.
     * 
     * @return the status value.
     */
    CapabilityStatus status();

    /**
     * Gets the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    String reason();

    /**
     * Gets the name property: Name of flexible servers capability.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the supportedServerEditions property: List of supported flexible server editions.
     * 
     * @return the supportedServerEditions value.
     */
    List<FlexibleServerEditionCapability> supportedServerEditions();

    /**
     * Gets the supportedServerVersions property: The list of server versions supported for this capability.
     * 
     * @return the supportedServerVersions value.
     */
    List<ServerVersionCapability> supportedServerVersions();

    /**
     * Gets the fastProvisioningSupported property: Gets a value indicating whether fast provisioning is supported.
     * "Enabled" means fast provisioning is supported. "Disabled" stands for fast provisioning is not supported.
     * 
     * @return the fastProvisioningSupported value.
     */
    FastProvisioningSupportedEnum fastProvisioningSupported();

    /**
     * Gets the supportedFastProvisioningEditions property: List of supported server editions for fast provisioning.
     * 
     * @return the supportedFastProvisioningEditions value.
     */
    List<FastProvisioningEditionCapability> supportedFastProvisioningEditions();

    /**
     * Gets the geoBackupSupported property: Determines if geo-backup is supported in this region. "Enabled" means
     * geo-backup is supported. "Disabled" stands for geo-back is not supported.
     * 
     * @return the geoBackupSupported value.
     */
    GeoBackupSupportedEnum geoBackupSupported();

    /**
     * Gets the zoneRedundantHaSupported property: A value indicating whether Zone Redundant HA is supported in this
     * region. "Enabled" means zone redundant HA is supported. "Disabled" stands for zone redundant HA is not supported.
     * 
     * @return the zoneRedundantHaSupported value.
     */
    ZoneRedundantHaSupportedEnum zoneRedundantHaSupported();

    /**
     * Gets the zoneRedundantHaAndGeoBackupSupported property: A value indicating whether Zone Redundant HA and
     * Geo-backup is supported in this region. "Enabled" means zone redundant HA and geo-backup is supported. "Disabled"
     * stands for zone redundant HA and geo-backup is not supported.
     * 
     * @return the zoneRedundantHaAndGeoBackupSupported value.
     */
    ZoneRedundantHaAndGeoBackupSupportedEnum zoneRedundantHaAndGeoBackupSupported();

    /**
     * Gets the storageAutoGrowthSupported property: A value indicating whether storage auto-grow is supported in this
     * region. "Enabled" means storage auto-grow is supported. "Disabled" stands for storage auto-grow is not supported.
     * 
     * @return the storageAutoGrowthSupported value.
     */
    StorageAutoGrowthSupportedEnum storageAutoGrowthSupported();

    /**
     * Gets the onlineResizeSupported property: A value indicating whether online resize is supported in this region for
     * the given subscription. "Enabled" means storage online resize is supported. "Disabled" means storage online
     * resize is not supported.
     * 
     * @return the onlineResizeSupported value.
     */
    OnlineResizeSupportedEnum onlineResizeSupported();

    /**
     * Gets the restricted property: A value indicating whether this region is restricted. "Enabled" means region is
     * restricted. "Disabled" stands for region is not restricted.
     * 
     * @return the restricted value.
     */
    RestrictedEnum restricted();

    /**
     * Gets the inner com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.FlexibleServerCapabilityInner
     * object.
     * 
     * @return the inner object.
     */
    FlexibleServerCapabilityInner innerModel();
}
