// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Flexible server edition capabilities.
 */
@Immutable
public final class FlexibleServerEditionCapability extends CapabilityBase {
    /*
     * Server edition name
     */
    private String name;

    /*
     * Default sku name for the server edition
     */
    private String defaultSkuName;

    /*
     * The list of editions supported by this server edition.
     */
    private List<StorageEditionCapability> supportedStorageEditions;

    /*
     * List of supported server SKUs.
     */
    private List<ServerSkuCapability> supportedServerSkus;

    /*
     * The reason for the capability not being available.
     */
    private String reason;

    /*
     * The status of the capability.
     */
    private CapabilityStatus status;

    /**
     * Creates an instance of FlexibleServerEditionCapability class.
     */
    public FlexibleServerEditionCapability() {
    }

    /**
     * Get the name property: Server edition name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the defaultSkuName property: Default sku name for the server edition.
     * 
     * @return the defaultSkuName value.
     */
    public String defaultSkuName() {
        return this.defaultSkuName;
    }

    /**
     * Get the supportedStorageEditions property: The list of editions supported by this server edition.
     * 
     * @return the supportedStorageEditions value.
     */
    public List<StorageEditionCapability> supportedStorageEditions() {
        return this.supportedStorageEditions;
    }

    /**
     * Get the supportedServerSkus property: List of supported server SKUs.
     * 
     * @return the supportedServerSkus value.
     */
    public List<ServerSkuCapability> supportedServerSkus() {
        return this.supportedServerSkus;
    }

    /**
     * Get the reason property: The reason for the capability not being available.
     * 
     * @return the reason value.
     */
    @Override
    public String reason() {
        return this.reason;
    }

    /**
     * Get the status property: The status of the capability.
     * 
     * @return the status value.
     */
    @Override
    public CapabilityStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (supportedStorageEditions() != null) {
            supportedStorageEditions().forEach(e -> e.validate());
        }
        if (supportedServerSkus() != null) {
            supportedServerSkus().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FlexibleServerEditionCapability from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FlexibleServerEditionCapability if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FlexibleServerEditionCapability.
     */
    public static FlexibleServerEditionCapability fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FlexibleServerEditionCapability deserializedFlexibleServerEditionCapability
                = new FlexibleServerEditionCapability();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.status
                        = CapabilityStatus.fromString(reader.getString());
                } else if ("reason".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.reason = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.name = reader.getString();
                } else if ("defaultSkuName".equals(fieldName)) {
                    deserializedFlexibleServerEditionCapability.defaultSkuName = reader.getString();
                } else if ("supportedStorageEditions".equals(fieldName)) {
                    List<StorageEditionCapability> supportedStorageEditions
                        = reader.readArray(reader1 -> StorageEditionCapability.fromJson(reader1));
                    deserializedFlexibleServerEditionCapability.supportedStorageEditions = supportedStorageEditions;
                } else if ("supportedServerSkus".equals(fieldName)) {
                    List<ServerSkuCapability> supportedServerSkus
                        = reader.readArray(reader1 -> ServerSkuCapability.fromJson(reader1));
                    deserializedFlexibleServerEditionCapability.supportedServerSkus = supportedServerSkus;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFlexibleServerEditionCapability;
        });
    }
}
