// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;

/**
 * The FlexibleServersTriggerLtrPreBackupHeaders model.
 */
@Fluent
public final class FlexibleServersTriggerLtrPreBackupHeaders {
    /*
     * The x-ms-request-id property.
     */
    private String xMsRequestId;

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of FlexibleServersTriggerLtrPreBackupHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public FlexibleServersTriggerLtrPreBackupHeaders(HttpHeaders rawHeaders) {
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     * 
     * @return the xMsRequestId value.
     */
    public String xMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     * 
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the FlexibleServersTriggerLtrPreBackupHeaders object itself.
     */
    public FlexibleServersTriggerLtrPreBackupHeaders withXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
