// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;

/**
 * Resource collection API of LocationBasedCapabilities.
 */
public interface LocationBasedCapabilities {
    /**
     * Get capabilities at specified location in a given subscription.
     * 
     * @param locationName The name of the location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return capabilities at specified location in a given subscription as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<FlexibleServerCapability> execute(String locationName);

    /**
     * Get capabilities at specified location in a given subscription.
     * 
     * @param locationName The name of the location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return capabilities at specified location in a given subscription as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<FlexibleServerCapability> execute(String locationName, Context context);
}
