// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request that is made for a long term retention backup.
 */
@Fluent
public final class LtrBackupRequest extends BackupRequestBase {
    /*
     * Backup store detail for target server
     */
    private BackupStoreDetails targetDetails;

    /**
     * Creates an instance of LtrBackupRequest class.
     */
    public LtrBackupRequest() {
    }

    /**
     * Get the targetDetails property: Backup store detail for target server.
     * 
     * @return the targetDetails value.
     */
    public BackupStoreDetails targetDetails() {
        return this.targetDetails;
    }

    /**
     * Set the targetDetails property: Backup store detail for target server.
     * 
     * @param targetDetails the targetDetails value to set.
     * @return the LtrBackupRequest object itself.
     */
    public LtrBackupRequest withTargetDetails(BackupStoreDetails targetDetails) {
        this.targetDetails = targetDetails;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LtrBackupRequest withBackupSettings(BackupSettings backupSettings) {
        super.withBackupSettings(backupSettings);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (targetDetails() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property targetDetails in model LtrBackupRequest"));
        } else {
            targetDetails().validate();
        }
        if (backupSettings() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property backupSettings in model LtrBackupRequest"));
        } else {
            backupSettings().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LtrBackupRequest.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backupSettings", backupSettings());
        jsonWriter.writeJsonField("targetDetails", this.targetDetails);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LtrBackupRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LtrBackupRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LtrBackupRequest.
     */
    public static LtrBackupRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LtrBackupRequest deserializedLtrBackupRequest = new LtrBackupRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("backupSettings".equals(fieldName)) {
                    deserializedLtrBackupRequest.withBackupSettings(BackupSettings.fromJson(reader));
                } else if ("targetDetails".equals(fieldName)) {
                    deserializedLtrBackupRequest.targetDetails = BackupStoreDetails.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLtrBackupRequest;
        });
    }
}
